/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ws.rest.impl.application;

import com.sun.ws.rest.api.container.ContainerException;
import com.sun.ws.rest.api.core.HttpContextAccess;
import com.sun.ws.rest.api.core.HttpRequestContext;
import com.sun.ws.rest.api.core.HttpResponseContext;
import com.sun.ws.rest.impl.application.WebApplicationImpl;
import com.sun.ws.rest.impl.model.ResourceClass;
import com.sun.ws.rest.impl.view.ViewFactory;
import com.sun.ws.rest.impl.view.ViewType;
import com.sun.ws.rest.spi.container.ContainerRequest;
import com.sun.ws.rest.spi.container.ContainerResponse;
import com.sun.ws.rest.spi.uri.rules.UriRule;
import com.sun.ws.rest.spi.uri.rules.UriRuleContext;
import com.sun.ws.rest.spi.uri.rules.UriRules;
import com.sun.ws.rest.spi.view.View;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class WebApplicationContext
implements HttpContextAccess,
UriRuleContext {
    private final ContainerRequest request;
    private final ContainerResponse response;
    private final WebApplicationImpl app;
    private Object it;
    private final List<String> capturingGroupValues = new ArrayList<String>();

    WebApplicationContext(WebApplicationImpl app, ContainerRequest request, ContainerResponse response) {
        this.app = app;
        this.request = request;
        this.response = response;
    }

    @Override
    public HttpRequestContext getHttpRequestContext() {
        return this.request;
    }

    @Override
    public HttpResponseContext getHttpResponseContext() {
        return this.response;
    }

    @Override
    public Response createLocalForward(String path) throws ContainerException {
        final View v = ViewFactory.createView(this.app.getComponentProvider(), path);
        if (v == null) {
            throw new ContainerException("No view for \"" + path + "\"");
        }
        ViewType vt = new ViewType(){

            public void process() throws IOException, ContainerException {
                v.dispatch(WebApplicationContext.this.it, WebApplicationContext.this.request, WebApplicationContext.this.response);
            }
        };
        return Response.ok((Object)vt, (MediaType)v.getProduceMime()).build();
    }

    @Override
    public HttpContextAccess getHttpContext() {
        return this;
    }

    @Override
    public Object getResource(Class resourceClass) {
        ResourceClass rc = this.app.getResourceClass(resourceClass);
        this.it = rc.resolver.getInstance(this.app.getComponentProvider(), this.request);
        return this.it;
    }

    @Override
    public UriRules<UriRule> getRules(Class resourceClass) {
        ResourceClass rc = this.app.getResourceClass(resourceClass);
        return rc.getRules();
    }

    @Override
    public List<String> getGroupValues() {
        return this.capturingGroupValues;
    }

    @Override
    public void setTemplateValues(List<String> names) {
        this.request.addTemplateValues(names, this.capturingGroupValues);
    }
}

