/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ws.rest.impl.container.grizzly;

import com.sun.grizzly.tcp.Response;
import com.sun.grizzly.util.buf.ByteChunk;
import com.sun.grizzly.util.buf.MessageBytes;
import com.sun.grizzly.util.http.MimeHeaders;
import com.sun.ws.rest.impl.container.grizzly.GrizzlyRequestAdaptor;
import com.sun.ws.rest.spi.container.AbstractContainerResponse;
import com.sun.ws.rest.spi.container.MessageBodyContext;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;

public final class GrizzlyResponseAdaptor
extends AbstractContainerResponse {
    private final Response response;
    private OutputStream output;

    GrizzlyResponseAdaptor(Response response, MessageBodyContext bodyContext, GrizzlyRequestAdaptor requestContext) {
        super(bodyContext, requestContext);
        this.response = response;
    }

    protected OutputStream getUnderlyingOutputStream() throws IOException {
        if (this.output != null) {
            return this.output;
        }
        this.output = new GrizzlyResponseOutputStream();
        return this.output;
    }

    protected void commitStatusAndHeaders() throws IOException {
        this.response.setStatus(this.getStatus());
        MimeHeaders mh = this.response.getMimeHeaders();
        for (Map.Entry e : this.getHttpHeaders().entrySet()) {
            String key = (String)e.getKey();
            for (Object value : (List)e.getValue()) {
                MessageBytes mb = mh.addValue(key);
                mb.setString(this.getHeaderValue(value));
            }
        }
        if (mh.getValue("Content-Type") != null) {
            this.response.setContentType(mh.getValue("Content-Type").getString());
        }
        this.response.sendHeaders();
    }

    void commitAll() throws IOException {
        if (this.isCommitted()) {
            this.getUnderlyingOutputStream().close();
            return;
        }
        this.commitStatusAndHeaders();
        OutputStream out = this.getUnderlyingOutputStream();
        this.writeEntity(out);
        out.close();
    }

    private final class GrizzlyResponseOutputStream
    extends OutputStream {
        public static final int BUFFER_SIZE = 4096;
        final ByteChunk chunk = new ByteChunk(4096);

        public void write(int b) throws IOException {
            if (this.chunk.getLength() > 4096) {
                this.flush();
            }
            this.chunk.append((byte)b);
        }

        public void write(byte[] b) throws IOException {
            if (this.chunk.getLength() > 4096) {
                this.flush();
            }
            this.chunk.append(b, 0, b.length);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            if (this.chunk.getLength() > 4096) {
                this.flush();
            }
            this.chunk.append(b, off, len);
        }

        public void flush() throws IOException {
            GrizzlyResponseAdaptor.this.response.doWrite(this.chunk);
            this.chunk.reset();
        }

        public void close() throws IOException {
            this.flush();
            this.chunk.recycle();
        }
    }
}

