/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ws.rest.impl.container.servlet;

import com.sun.ws.rest.api.container.ContainerException;
import com.sun.ws.rest.api.core.HttpRequestContext;
import com.sun.ws.rest.api.core.HttpResponseContext;
import com.sun.ws.rest.impl.container.servlet.HttpResponseAdaptor;
import com.sun.ws.rest.spi.view.View;
import com.sun.ws.rest.spi.view.ViewProvider;
import java.net.MalformedURLException;
import javax.annotation.Resource;
import javax.servlet.ServletContext;
import javax.ws.rs.core.MediaType;

public class JSPViewProvider
implements ViewProvider {
    @Resource
    ServletContext servletContext;

    public View createView(String absolutePath) throws ContainerException {
        if (!absolutePath.endsWith(".jsp")) {
            return null;
        }
        if (this.servletContext == null) {
            throw new ContainerException("Java Server Pages not supported by the container");
        }
        try {
            if (this.servletContext.getResource(absolutePath) == null) {
                return null;
            }
        }
        catch (MalformedURLException ex) {
            return null;
        }
        return new JSPView(absolutePath);
    }

    static final class JSPView
    implements View {
        private final String path;
        private final MediaType mediaType;

        JSPView(String path) {
            this.path = path;
            this.mediaType = new MediaType("text", "html");
        }

        public void dispatch(Object it, HttpRequestContext request, HttpResponseContext response) {
            ((HttpResponseAdaptor)response).forwardTo(this.path, it);
        }

        public MediaType getProduceMime() {
            return this.mediaType;
        }
    }
}

