/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ws.rest.impl.uri.rules;

import com.sun.ws.rest.api.container.ContainerException;
import com.sun.ws.rest.api.core.HttpRequestContext;
import com.sun.ws.rest.impl.model.parameter.ParameterExtractor;
import com.sun.ws.rest.impl.uri.rules.BaseRule;
import com.sun.ws.rest.spi.uri.rules.UriRule;
import com.sun.ws.rest.spi.uri.rules.UriRuleContext;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.WebApplicationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SubLocatorRule
extends BaseRule {
    private final ParameterExtractor[] extractors;
    private final Method m;

    public SubLocatorRule(List<String> groupNames, Method m, ParameterExtractor[] extractors) {
        super(groupNames);
        this.m = m;
        this.extractors = extractors;
    }

    @Override
    public boolean accept(CharSequence path, Object resource, UriRuleContext context) {
        this.setTemplateValues(context);
        resource = this.invokeSubLocator(resource, context);
        Iterator<UriRule> matches = context.getRules(resource.getClass()).match(path, context.getGroupValues());
        while (matches.hasNext()) {
            if (!matches.next().accept(path, resource, context)) continue;
            return true;
        }
        return false;
    }

    private Object invokeSubLocator(Object resource, UriRuleContext context) {
        try {
            if (this.extractors == null) {
                return this.m.invoke(resource, new Object[0]);
            }
            HttpRequestContext request = context.getHttpContext().getHttpRequestContext();
            Object[] params = new Object[this.extractors.length];
            for (int i = 0; i < this.extractors.length; ++i) {
                params[i] = this.extractors[i].extract(request);
            }
            return this.m.invoke(resource, params);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new ContainerException(t);
        }
        catch (IllegalAccessException e) {
            throw new ContainerException(e);
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new ContainerException("Exception injecting parameters to dynamic resolving method", e);
        }
    }
}

