/*
 * Decompiled with CFR 0.152.
 */
package javax.ws.rs.core;

import java.net.URI;
import java.util.Date;
import java.util.List;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Variant;
import javax.ws.rs.ext.RuntimeDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Response {
    public abstract Object getEntity();

    public abstract int getStatus();

    public abstract MultivaluedMap<String, Object> getMetadata();

    public static ResponseBuilder fromResponse(Response response) {
        ResponseBuilder b = ResponseBuilder.newInstance();
        b.status(response.getStatus());
        b.entity(response.getEntity());
        for (String headerName : response.getMetadata().keySet()) {
            List headerValues = (List)response.getMetadata().get(headerName);
            for (Object headerValue : headerValues) {
                b.header(headerName, headerValue);
            }
        }
        return b;
    }

    public static ResponseBuilder status(int status) {
        ResponseBuilder b = ResponseBuilder.newInstance();
        b.status(status);
        return b;
    }

    public static ResponseBuilder ok() {
        ResponseBuilder b = Response.status(200);
        return b;
    }

    public static ResponseBuilder ok(Object entity) {
        ResponseBuilder b = Response.ok();
        b.entity(entity);
        return b;
    }

    public static ResponseBuilder ok(Object entity, MediaType type) {
        ResponseBuilder b = Response.ok();
        b.entity(entity);
        b.type(type);
        return b;
    }

    public static ResponseBuilder ok(Object entity, String type) {
        ResponseBuilder b = Response.ok();
        b.entity(entity);
        b.type(type);
        return b;
    }

    public static ResponseBuilder ok(Object entity, Variant variant) {
        ResponseBuilder b = Response.ok();
        b.entity(entity);
        b.variant(variant);
        return b;
    }

    public static ResponseBuilder serverError() {
        ResponseBuilder b = Response.status(500);
        return b;
    }

    public static ResponseBuilder created(URI location) {
        ResponseBuilder b = Response.status(201).location(location);
        return b;
    }

    public static ResponseBuilder noContent() {
        ResponseBuilder b = Response.status(204);
        return b;
    }

    public static ResponseBuilder notModified() {
        ResponseBuilder b = Response.status(304);
        return b;
    }

    public static ResponseBuilder notModified(EntityTag tag) {
        ResponseBuilder b = Response.notModified();
        b.tag(tag);
        return b;
    }

    public static ResponseBuilder notModified(String tag) {
        ResponseBuilder b = Response.notModified();
        b.tag(tag);
        return b;
    }

    public static ResponseBuilder seeOther(URI location) {
        ResponseBuilder b = Response.status(303).location(location);
        return b;
    }

    public static ResponseBuilder temporaryRedirect(URI location) {
        ResponseBuilder b = Response.status(307).location(location);
        return b;
    }

    public static ResponseBuilder notAcceptable(List<Variant> variants) {
        ResponseBuilder b = Response.status(406).variants(variants);
        return b;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class ResponseBuilder {
        protected ResponseBuilder() {
        }

        protected static ResponseBuilder newInstance() {
            ResponseBuilder b = RuntimeDelegate.getInstance().createResponseBuilder();
            return b;
        }

        public abstract Response build();

        public abstract ResponseBuilder clone();

        public abstract ResponseBuilder status(int var1);

        public abstract ResponseBuilder entity(Object var1);

        public abstract ResponseBuilder type(MediaType var1);

        public abstract ResponseBuilder type(String var1);

        public abstract ResponseBuilder variant(Variant var1);

        public abstract ResponseBuilder variants(List<Variant> var1);

        public abstract ResponseBuilder language(String var1);

        public abstract ResponseBuilder location(URI var1);

        public abstract ResponseBuilder contentLocation(URI var1);

        public abstract ResponseBuilder tag(EntityTag var1);

        public abstract ResponseBuilder tag(String var1);

        public abstract ResponseBuilder lastModified(Date var1);

        public abstract ResponseBuilder cacheControl(CacheControl var1);

        public abstract ResponseBuilder header(String var1, Object var2);

        public abstract ResponseBuilder cookie(NewCookie ... var1);
    }
}

