/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.Serializable;

public class Payload
implements Serializable {
    protected byte[] data;
    protected int offset;
    protected int length;

    protected Payload() {
    }

    public Payload(byte[] data) {
        this(data, 0, data.length);
    }

    public Payload(byte[] data, int offset, int length) {
        if (offset < 0 || offset + length > data.length) {
            throw new IllegalArgumentException();
        }
        this.data = data;
        this.offset = offset;
        this.length = length;
    }

    public int length() {
        return this.length;
    }

    public byte byteAt(int index) {
        if (0 <= index && index < this.length) {
            return this.data[this.offset + index];
        }
        throw new ArrayIndexOutOfBoundsException(index);
    }

    public byte[] toByteArray() {
        byte[] retArray = new byte[this.length];
        System.arraycopy(this.data, this.offset, retArray, 0, this.length);
        return retArray;
    }

    public void copyTo(byte[] target, int targetOffset) {
        if (this.length > target.length + targetOffset) {
            throw new ArrayIndexOutOfBoundsException();
        }
        System.arraycopy(this.data, this.offset, target, targetOffset, this.length);
    }
}

