/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite;

import java.sql.BatchUpdateException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.sqlite.Codes;
import org.sqlite.Conn;
import org.sqlite.DB;
import org.sqlite.RS;

class Stmt
extends RS
implements Statement,
Codes {
    private ArrayList batch = null;

    Stmt(Conn conn) {
        super(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean exec() throws SQLException {
        if (this.pointer == 0L) {
            throw new SQLException("SQLite JDBC internal error: pointer == 0 on exec.");
        }
        if (this.isRS()) {
            throw new SQLException("SQLite JDBC internal error: isRS() on exec.");
        }
        boolean bl = false;
        try {
            bl = this.db.execute(this, null);
        }
        finally {
            this.resultsWaiting = bl;
        }
        return this.db.column_count(this.pointer) != 0;
    }

    public Statement getStatement() {
        return this;
    }

    public void close() throws SQLException {
        if (this.pointer == 0L) {
            return;
        }
        this.clearRS();
        this.colsMeta = null;
        this.meta = null;
        this.batch = null;
        int n = this.db.finalize(this);
        if (n != 0 && n != 21) {
            this.db.throwex();
        }
    }

    protected void finalize() throws SQLException {
        this.close();
    }

    public int getUpdateCount() throws SQLException {
        this.checkOpen();
        if (this.pointer == 0L || this.resultsWaiting) {
            return -1;
        }
        return this.db.changes();
    }

    public boolean execute(String string) throws SQLException {
        this.checkOpen();
        this.close();
        this.sql = string;
        this.db.prepare(this);
        return this.exec();
    }

    public ResultSet executeQuery(String string) throws SQLException {
        this.checkOpen();
        this.close();
        this.sql = string;
        this.db.prepare(this);
        if (!this.exec()) {
            this.close();
            throw new SQLException("query does not return ResultSet");
        }
        return this.getResultSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(String string) throws SQLException {
        this.checkOpen();
        this.close();
        this.sql = string;
        int n = 0;
        try {
            this.db.prepare(this);
            n = this.db.executeUpdate(this, null);
        }
        finally {
            this.close();
        }
        return n;
    }

    public void addBatch(String string) throws SQLException {
        this.checkOpen();
        if (this.batch == null) {
            this.batch = new ArrayList();
        }
        this.batch.add(string);
    }

    public void clearBatch() throws SQLException {
        this.checkOpen();
        if (this.batch != null) {
            this.batch.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] executeBatch() throws SQLException {
        this.checkOpen();
        this.close();
        if (this.batch == null) {
            return new int[0];
        }
        int[] nArray = new int[this.batch.size()];
        DB dB = this.db;
        synchronized (dB) {
            try {
                for (int i = 0; i < nArray.length; ++i) {
                    try {
                        this.sql = (String)this.batch.get(i);
                        this.db.prepare(this);
                        nArray[i] = this.db.executeUpdate(this, null);
                        continue;
                    }
                    catch (SQLException sQLException) {
                        throw new BatchUpdateException("batch entry " + i + ": " + sQLException.getMessage(), nArray);
                    }
                    finally {
                        this.db.finalize(this);
                    }
                }
            }
            finally {
                this.batch.clear();
            }
        }
        return nArray;
    }
}

