/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.auth;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.BasicSSLManager;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationProvider;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationStorage;
import org.tmatesoft.svn.core.auth.ISVNProxyManager;
import org.tmatesoft.svn.core.auth.ISVNSSLManager;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.auth.SVNPasswordAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSHAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSLAuthentication;
import org.tmatesoft.svn.core.auth.SVNUserNameAuthentication;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.io.SVNRepository;

public class BasicAuthenticationManager
implements ISVNAuthenticationManager,
ISVNProxyManager {
    private List myPasswordAuthentications;
    private List mySSHAuthentications;
    private List myUserNameAuthentications;
    private SVNSSLAuthentication mySSLAuthentication;
    private int mySSHIndex;
    private int myPasswordIndex;
    private int myUserNameIndex;
    private String myProxyHost;
    private int myProxyPort;
    private String myProxyUserName;
    private String myProxyPassword;
    private boolean myIsAuthenticationForced;

    public BasicAuthenticationManager(String userName, String password) {
        this.setAuthentications(new SVNAuthentication[]{new SVNPasswordAuthentication(userName, password, false), new SVNSSHAuthentication(userName, password, -1, false), new SVNUserNameAuthentication(userName, false)});
    }

    public BasicAuthenticationManager(String userName, File keyFile, String passphrase, int portNumber) {
        this.setAuthentications(new SVNAuthentication[]{new SVNSSHAuthentication(userName, keyFile, passphrase, portNumber, false), new SVNUserNameAuthentication(userName, false)});
    }

    public BasicAuthenticationManager(SVNAuthentication[] authentications) {
        this.setAuthentications(authentications);
    }

    public void setAuthentications(SVNAuthentication[] authentications) {
        this.myPasswordAuthentications = new ArrayList();
        this.mySSHAuthentications = new ArrayList();
        this.myUserNameAuthentications = new ArrayList();
        this.myPasswordIndex = 0;
        this.mySSHIndex = 0;
        for (int i = 0; authentications != null && i < authentications.length; ++i) {
            SVNAuthentication auth = authentications[i];
            if (auth instanceof SVNPasswordAuthentication) {
                this.myPasswordAuthentications.add(auth);
                continue;
            }
            if (auth instanceof SVNSSHAuthentication) {
                this.mySSHAuthentications.add(auth);
                continue;
            }
            if (auth instanceof SVNUserNameAuthentication) {
                this.myUserNameAuthentications.add(auth);
                continue;
            }
            if (!(auth instanceof SVNSSLAuthentication)) continue;
            this.mySSLAuthentication = (SVNSSLAuthentication)auth;
        }
    }

    public void setProxy(String proxyHost, int proxyPort, String proxyUserName, String proxyPassword) {
        this.myProxyHost = proxyHost;
        this.myProxyPort = proxyPort >= 0 ? proxyPort : 3128;
        this.myProxyUserName = proxyUserName;
        this.myProxyPassword = proxyPassword;
    }

    public SVNAuthentication getFirstAuthentication(String kind, String realm, SVNURL url) throws SVNException {
        if ("svn.ssh".equals(kind) && this.mySSHAuthentications.size() > 0) {
            this.mySSHIndex = 0;
            return (SVNAuthentication)this.mySSHAuthentications.get(0);
        }
        if ("svn.simple".equals(kind) && this.myPasswordAuthentications.size() > 0) {
            this.myPasswordIndex = 0;
            return (SVNAuthentication)this.myPasswordAuthentications.get(0);
        }
        if ("svn.username".equals(kind) && this.myUserNameAuthentications.size() > 0) {
            this.myUserNameIndex = 0;
            return (SVNAuthentication)this.myUserNameAuthentications.get(0);
        }
        if ("svn.username".equals(kind)) {
            if (url.getUserInfo() != null && !"".equals(url.getUserInfo())) {
                return new SVNUserNameAuthentication(url.getUserInfo(), false);
            }
            return new SVNUserNameAuthentication(null, false);
        }
        SVNErrorManager.authenticationFailed("Authentication required for ''{0}''", realm);
        return null;
    }

    public SVNAuthentication getNextAuthentication(String kind, String realm, SVNURL url) throws SVNException {
        if ("svn.ssh".equals(kind) && this.mySSHIndex + 1 < this.mySSHAuthentications.size()) {
            ++this.mySSHIndex;
            return (SVNAuthentication)this.mySSHAuthentications.get(this.mySSHIndex);
        }
        if ("svn.simple".equals(kind) && this.myPasswordIndex + 1 < this.myPasswordAuthentications.size()) {
            ++this.myPasswordIndex;
            return (SVNAuthentication)this.myPasswordAuthentications.get(this.myPasswordIndex);
        }
        if ("svn.username".equals(kind) && this.myUserNameIndex + 1 < this.myUserNameAuthentications.size()) {
            ++this.myUserNameIndex;
            return (SVNAuthentication)this.myUserNameAuthentications.get(this.myUserNameIndex);
        }
        SVNErrorManager.authenticationFailed("Authentication required for ''{0}''", realm);
        return null;
    }

    public void setAuthenticationProvider(ISVNAuthenticationProvider provider) {
    }

    public ISVNProxyManager getProxyManager(SVNURL url) throws SVNException {
        return this;
    }

    public ISVNSSLManager getSSLManager(SVNURL url) throws SVNException {
        if (this.mySSLAuthentication != null) {
            return new BasicSSLManager(this.mySSLAuthentication);
        }
        return null;
    }

    public void acknowledgeAuthentication(boolean accepted, String kind, String realm, SVNErrorMessage errorMessage, SVNAuthentication authentication) {
    }

    public void setRuntimeStorage(ISVNAuthenticationStorage storage) {
    }

    public boolean isAuthenticationForced() {
        return this.myIsAuthenticationForced;
    }

    public void setAuthenticationForced(boolean forced) {
        this.myIsAuthenticationForced = forced;
    }

    public String getProxyHost() {
        return this.myProxyHost;
    }

    public int getProxyPort() {
        return this.myProxyPort;
    }

    public String getProxyUserName() {
        return this.myProxyUserName;
    }

    public String getProxyPassword() {
        return this.myProxyPassword;
    }

    public void acknowledgeProxyContext(boolean accepted, SVNErrorMessage errorMessage) {
    }

    public long getHTTPTimeout(SVNRepository repository) {
        return 3600000L;
    }
}

