/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.auth;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.auth.ISVNSSLManager;
import org.tmatesoft.svn.core.auth.SVNSSLAuthentication;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;

public class BasicSSLManager
implements ISVNSSLManager {
    private SVNSSLAuthentication mySSLAuthentication;
    private Throwable myLoadError;

    public BasicSSLManager(SVNSSLAuthentication sslAuthentication) {
        this.mySSLAuthentication = sslAuthentication;
    }

    public SSLContext getSSLContext() throws IOException, SVNException {
        try {
            SSLContext context = SSLContext.getInstance("SSLv3");
            context.init(this.getKeyManagers(), new TrustManager[]{new X509TrustManager(){

                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            }}, null);
            return context;
        }
        catch (NoSuchAlgorithmException nsae) {
            throw (IOException)new IOException(nsae.getMessage()).initCause(nsae);
        }
        catch (KeyManagementException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
    }

    public boolean isClientCertPromptRequired() {
        return false;
    }

    public SVNSSLAuthentication getClientAuthentication() {
        return this.mySSLAuthentication;
    }

    public void setClientAuthentication(SVNSSLAuthentication sslAuthentication) {
        this.mySSLAuthentication = sslAuthentication;
    }

    public Throwable getClientCertLoadingError() {
        return this.myLoadError;
    }

    public void acknowledgeSSLContext(boolean accepted, SVNErrorMessage errorMessage) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyManager[] getKeyManagers() {
        InputStream is;
        char[] passphrase = null;
        String password = this.mySSLAuthentication.getPassword();
        File certFile = this.mySSLAuthentication.getCertificateFile();
        if (password != null) {
            passphrase = password.toCharArray();
        }
        KeyStore keyStore = null;
        try {
            is = SVNFileUtil.openFileForReading(certFile);
        }
        catch (SVNException e1) {
            this.myLoadError = e1;
            return null;
        }
        try {
            keyStore = KeyStore.getInstance("PKCS12");
            if (keyStore != null) {
                keyStore.load(is, passphrase);
            }
        }
        catch (Throwable th) {
            this.myLoadError = th;
            KeyManager[] keyManagerArray = null;
            return keyManagerArray;
        }
        finally {
            SVNFileUtil.closeFile(is);
        }
        KeyManagerFactory kmf = null;
        KeyManager[] result = null;
        if (keyStore != null) {
            try {
                kmf = KeyManagerFactory.getInstance("SunX509");
                if (kmf != null) {
                    kmf.init(keyStore, passphrase);
                    result = kmf.getKeyManagers();
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        return result;
    }
}

