/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.regex.Pattern;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNTimeUtil;
import org.tmatesoft.svn.core.internal.util.SVNUUIDGenerator;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileListUtil;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNProperties;
import org.tmatesoft.svn.core.internal.wc.admin.SVNTranslator;
import org.tmatesoft.svn.core.io.ISVNSession;
import org.tmatesoft.svn.core.io.SVNRepository;

public abstract class SVNRepositoryFactory {
    private static final Map myFactoriesMap = new HashMap();
    private static final String REPOSITORY_TEMPLATE_PATH = "/org/tmatesoft/svn/core/io/repository/template.jar";
    static /* synthetic */ Class class$org$tmatesoft$svn$core$io$SVNRepositoryFactory;

    protected static void registerRepositoryFactory(String protocol, SVNRepositoryFactory factory) {
        if (protocol != null && factory != null) {
            myFactoriesMap.put(protocol, factory);
        }
    }

    protected static boolean hasRepositoryFactory(String protocol) {
        if (protocol != null) {
            return myFactoriesMap.get(protocol) != null;
        }
        return false;
    }

    public static SVNRepository create(SVNURL url) throws SVNException {
        return SVNRepositoryFactory.create(url, null);
    }

    public static SVNRepository create(SVNURL url, ISVNSession options) throws SVNException {
        SVNErrorMessage err;
        String urlString = url.toString();
        Iterator keys = myFactoriesMap.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (!Pattern.matches(key, urlString)) continue;
            return ((SVNRepositoryFactory)myFactoriesMap.get(key)).createRepositoryImpl(url, options);
        }
        if ("file".equalsIgnoreCase(url.getProtocol())) {
            err = SVNErrorMessage.create(SVNErrorCode.RA_LOCAL_REPOS_OPEN_FAILED, "Unable to open an ra_local session to URL");
            SVNErrorManager.error(err);
        }
        err = SVNErrorMessage.create(SVNErrorCode.BAD_URL, "Unable to create SVNRepository object for ''{0}''", url);
        SVNErrorManager.error(err);
        return null;
    }

    public static SVNURL createLocalRepository(File path, boolean enableRevisionProperties, boolean force) throws SVNException {
        return SVNRepositoryFactory.createLocalRepository(path, null, enableRevisionProperties, force);
    }

    public static SVNURL createLocalRepository(File path, String uuid, boolean enableRevisionProperties, boolean force) throws SVNException {
        return SVNRepositoryFactory.createLocalRepository(path, uuid, enableRevisionProperties, force, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SVNURL createLocalRepository(File path, String uuid, boolean enableRevisionProperties, boolean force, boolean pre14Compatible) throws SVNException {
        InputStream is;
        SVNErrorMessage err;
        SVNErrorMessage err2;
        SVNFileType fType = SVNFileType.getType(path);
        if (fType != SVNFileType.NONE) {
            if (fType == SVNFileType.DIRECTORY) {
                File[] children = SVNFileListUtil.listFiles(path);
                if (children != null && children.length != 0) {
                    if (!force) {
                        err2 = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "''{0}'' already exists; use ''force'' to overwrite existing files", path);
                        SVNErrorManager.error(err2);
                    } else {
                        SVNFileUtil.deleteAll(path, true);
                    }
                }
            } else if (!force) {
                err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "''{0}'' already exists; use ''force'' to overwrite existing files", path);
                SVNErrorManager.error(err);
            } else {
                SVNFileUtil.deleteAll(path, true);
            }
        }
        if (!path.mkdirs() && !path.exists()) {
            err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Can not create directory ''{0}''", path);
            SVNErrorManager.error(err);
        }
        if ((is = (class$org$tmatesoft$svn$core$io$SVNRepositoryFactory == null ? (class$org$tmatesoft$svn$core$io$SVNRepositoryFactory = SVNRepositoryFactory.class$("org.tmatesoft.svn.core.io.SVNRepositoryFactory")) : class$org$tmatesoft$svn$core$io$SVNRepositoryFactory).getResourceAsStream(REPOSITORY_TEMPLATE_PATH)) == null) {
            err2 = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "No repository template found; should be part of SVNKit library jar");
            SVNErrorManager.error(err2);
        }
        File jarFile = SVNFileUtil.createUniqueFile(path, ".template", ".jar", true);
        OutputStream uuidOS = null;
        OutputStream reposFormatOS = null;
        OutputStream fsFormatOS = null;
        try {
            SVNErrorMessage err3;
            SVNRepositoryFactory.copyToFile(is, jarFile);
            SVNRepositoryFactory.extract(jarFile, path);
            if (!SVNFileUtil.isWindows) {
                SVNRepositoryFactory.translateFiles(path);
                SVNRepositoryFactory.translateFiles(new File(path, "conf"));
                SVNRepositoryFactory.translateFiles(new File(path, "hooks"));
                SVNRepositoryFactory.translateFiles(new File(path, "locks"));
            }
            if (enableRevisionProperties) {
                if (SVNFileUtil.isWindows) {
                    SVNFileUtil.createEmptyFile(new File(path, "hooks/pre-revprop-change.bat"));
                } else {
                    File hookFile = new File(path, "hooks/pre-revprop-change");
                    OutputStream os = null;
                    try {
                        os = SVNFileUtil.openFileForWriting(hookFile);
                        os.write("#!/bin/sh\nexit 0".getBytes("US-ASCII"));
                    }
                    catch (IOException e) {
                        err3 = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot create pre-rev-prop-change hook file at ''{0}'': {1}", new Object[]{hookFile, e.getLocalizedMessage()});
                        SVNErrorManager.error(err3);
                    }
                    finally {
                        SVNFileUtil.closeFile(os);
                    }
                    SVNFileUtil.setExecutable(hookFile, true);
                }
            }
            File uuidFile = new File(path, "db/uuid");
            if (uuid == null || uuid.length() != 36) {
                byte[] uuidBytes = SVNUUIDGenerator.generateUUID();
                uuid = SVNUUIDGenerator.formatUUID(uuidBytes);
            }
            uuid = uuid + '\n';
            try {
                uuidOS = SVNFileUtil.openFileForWriting(uuidFile);
                uuidOS.write(uuid.getBytes("US-ASCII"));
            }
            catch (IOException e) {
                SVNErrorMessage err4 = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Error writing repository UUID to ''{0}''", uuidFile);
                err4.setChildErrorMessage(SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getLocalizedMessage()));
                SVNErrorManager.error(err4);
            }
            if (pre14Compatible) {
                File reposFormatFile = new File(path, "format");
                try {
                    reposFormatOS = SVNFileUtil.openFileForWriting(reposFormatFile);
                    reposFormatOS.write("3\n".getBytes("US-ASCII"));
                }
                catch (IOException e) {
                    err3 = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Error writing repository format to ''{0}''", reposFormatFile);
                    err3.setChildErrorMessage(SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getLocalizedMessage()));
                    SVNErrorManager.error(err3);
                }
                File fsFormatFile = new File(path, "db/format");
                try {
                    fsFormatOS = SVNFileUtil.openFileForWriting(fsFormatFile);
                    fsFormatOS.write("1\n".getBytes("US-ASCII"));
                }
                catch (IOException e) {
                    SVNErrorMessage err5 = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Error writing fs format to ''{0}''", fsFormatFile);
                    err5.setChildErrorMessage(SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getLocalizedMessage()));
                    SVNErrorManager.error(err5);
                }
            }
            File rev0File = new File(path, "db/revprops/0");
            SVNProperties props = new SVNProperties(rev0File, null);
            String date = SVNTimeUtil.formatDate(new Date(System.currentTimeMillis()), true);
            props.setPropertyValue("svn:date", date);
            Object var17_21 = null;
        }
        catch (Throwable throwable) {
            Object var17_22 = null;
            SVNFileUtil.closeFile(uuidOS);
            SVNFileUtil.closeFile(reposFormatOS);
            SVNFileUtil.closeFile(fsFormatOS);
            SVNFileUtil.deleteFile(jarFile);
            throw throwable;
        }
        SVNFileUtil.closeFile(uuidOS);
        SVNFileUtil.closeFile(reposFormatOS);
        SVNFileUtil.closeFile(fsFormatOS);
        SVNFileUtil.deleteFile(jarFile);
        return SVNURL.fromFile(path);
    }

    protected abstract SVNRepository createRepositoryImpl(SVNURL var1, ISVNSession var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyToFile(InputStream is, File dstFile) throws SVNException {
        OutputStream os = null;
        byte[] buffer = new byte[16384];
        try {
            int r;
            os = SVNFileUtil.openFileForWriting(dstFile);
            while ((r = is.read(buffer)) > 0) {
                os.write(buffer, 0, r);
            }
        }
        catch (IOException e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Can not copy repository template file to ''{0}''", dstFile);
            err.setChildErrorMessage(SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getLocalizedMessage()));
            SVNErrorManager.error(err);
        }
        finally {
            SVNFileUtil.closeFile(os);
            SVNFileUtil.closeFile(is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void extract(File srcFile, File dst) throws SVNException {
        block18: {
            JarInputStream jis = null;
            InputStream is = SVNFileUtil.openFileForReading(srcFile);
            byte[] buffer = new byte[16384];
            JarFile jarFile = null;
            try {
                JarEntry entry;
                jarFile = new JarFile(srcFile);
                jis = new JarInputStream(is);
                while ((entry = jis.getNextJarEntry()) != null) {
                    block17: {
                        OutputStream fos;
                        BufferedInputStream fis;
                        String name = entry.getName();
                        File entryFile = new File(dst, name);
                        if (entry.isDirectory()) {
                            entryFile.mkdirs();
                        } else {
                            int r;
                            fis = null;
                            fos = null;
                            fis = new BufferedInputStream(jarFile.getInputStream(entry));
                            fos = SVNFileUtil.openFileForWriting(entryFile);
                            while ((r = ((InputStream)fis).read(buffer)) > 0) {
                                fos.write(buffer, 0, r);
                            }
                            SVNFileUtil.closeFile(fos);
                            SVNFileUtil.closeFile(fis);
                        }
                        break block17;
                        catch (Throwable throwable) {
                            SVNFileUtil.closeFile(fos);
                            SVNFileUtil.closeFile(fis);
                            throw throwable;
                        }
                    }
                    jis.closeEntry();
                }
                Object var14_15 = null;
            }
            catch (Throwable throwable) {
                Object var14_17 = null;
                SVNFileUtil.closeFile(jis);
                SVNFileUtil.closeFile(is);
                if (jarFile != null) {
                    try {
                        jarFile.close();
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            SVNFileUtil.closeFile(jis);
            SVNFileUtil.closeFile(is);
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException e2) {}
            }
            break block18;
            {
                catch (IOException e) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Can not extract repository files from ''{0}'' to ''{1}''", new Object[]{srcFile, dst});
                    err.setChildErrorMessage(SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getLocalizedMessage()));
                    SVNErrorManager.error(err);
                    Object var14_16 = null;
                    SVNFileUtil.closeFile(jis);
                    SVNFileUtil.closeFile(is);
                    if (jarFile != null) {
                        try {
                            jarFile.close();
                        }
                        catch (IOException e2) {}
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void translateFiles(File directory) throws SVNException {
        File[] children = SVNFileListUtil.listFiles(directory);
        byte[] eol = new byte[]{10};
        for (int i = 0; children != null && i < children.length; ++i) {
            File child = children[i];
            File tmpChild = null;
            if (!child.isFile()) continue;
            try {
                tmpChild = SVNFileUtil.createUniqueFile(directory, ".repos", ".tmp", true);
                SVNTranslator.translate(child, tmpChild, eol, null, false, true);
                SVNFileUtil.deleteFile(child);
                SVNFileUtil.rename(tmpChild, child);
            }
            catch (Throwable throwable) {
                SVNFileUtil.deleteFile(tmpChild);
                throw throwable;
            }
            SVNFileUtil.deleteFile(tmpChild);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

