/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.command;

import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import org.tmatesoft.svn.cli.SVNArgument;
import org.tmatesoft.svn.cli.SVNCommand;
import org.tmatesoft.svn.cli.command.SVNCommandEventProcessor;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNCopyClient;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class SVNCopyCommand
extends SVNCommand {
    public void run(InputStream in, PrintStream out, PrintStream err) throws SVNException {
        this.run(out, err);
    }

    public void run(PrintStream out, PrintStream err) throws SVNException {
        if (this.getCommandLine().hasURLs()) {
            if (this.getCommandLine().hasPaths()) {
                String path = this.getCommandLine().getPathAt(0);
                String url = this.getCommandLine().getURL(0);
                if (this.getCommandLine().isPathURLBefore(url, path)) {
                    if (this.getCommandLine().getArgumentValue(SVNArgument.MESSAGE) != null) {
                        SVNErrorMessage msg = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_UNNECESSARY_LOG_MESSAGE, (String)"Local, non-commit operations do not take a log message.");
                        throw new SVNException(msg);
                    }
                    this.runRemoteToLocal(out, err);
                } else {
                    this.runLocalToRemote(out, err);
                }
            } else {
                this.runRemote(out, err);
            }
        } else {
            if (this.getCommandLine().getArgumentValue(SVNArgument.MESSAGE) != null) {
                SVNErrorMessage msg = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_UNNECESSARY_LOG_MESSAGE, (String)"Local, non-commit operations do not take a log message.");
                throw new SVNException(msg);
            }
            this.runLocally(out, err);
        }
    }

    private void runLocally(PrintStream out, PrintStream err) throws SVNException {
        if (this.getCommandLine().getPathCount() != 2) {
            SVNErrorMessage msg = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_INSUFFICIENT_ARGS, (String)"Please enter SRC and DST path");
            throw new SVNException(msg);
        }
        String absoluteSrcPath = this.getCommandLine().getPathAt(0);
        String absoluteDstPath = this.getCommandLine().getPathAt(1);
        if (SVNCopyCommand.matchTabsInPath(absoluteDstPath, err) || SVNCopyCommand.matchTabsInPath(absoluteSrcPath, err)) {
            return;
        }
        this.getClientManager().setEventHandler((ISVNEventHandler)new SVNCommandEventProcessor(out, err, false));
        SVNCopyClient updater = this.getClientManager().getCopyClient();
        boolean force = this.getCommandLine().hasArgument(SVNArgument.FORCE);
        SVNRevision srcRevision = SVNRevision.parse((String)((String)this.getCommandLine().getArgumentValue(SVNArgument.REVISION)));
        updater.doCopy(new File(absoluteSrcPath), srcRevision, new File(absoluteDstPath), force, false);
    }

    private void runRemote(PrintStream out, PrintStream err) throws SVNException {
        if (this.getCommandLine().getURLCount() != 2) {
            SVNErrorMessage msg = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_INSUFFICIENT_ARGS, (String)"Please enter SRC and DST URLs");
            throw new SVNException(msg);
        }
        String srcURL = this.getCommandLine().getURL(0);
        SVNRevision srcRevision = SVNRevision.parse((String)((String)this.getCommandLine().getArgumentValue(SVNArgument.REVISION)));
        String dstURL = this.getCommandLine().getURL(1);
        if (SVNCopyCommand.matchTabsInURL(srcURL, err) || SVNCopyCommand.matchTabsInURL(dstURL, err)) {
            return;
        }
        String commitMessage = this.getCommitMessage();
        this.getClientManager().setEventHandler((ISVNEventHandler)new SVNCommandEventProcessor(out, err, false));
        SVNCopyClient updater = this.getClientManager().getCopyClient();
        SVNCommitInfo result = updater.doCopy(SVNURL.parseURIEncoded((String)srcURL), srcRevision, SVNURL.parseURIEncoded((String)dstURL), false, commitMessage);
        if (result != SVNCommitInfo.NULL) {
            out.println();
            out.println("Committed revision " + result.getNewRevision() + ".");
        }
    }

    private void runRemoteToLocal(PrintStream out, PrintStream err) throws SVNException {
        String srcURL = this.getCommandLine().getURL(0);
        String dstPath = this.getCommandLine().getPathAt(0);
        SVNRevision revision = SVNRevision.parse((String)((String)this.getCommandLine().getArgumentValue(SVNArgument.REVISION)));
        if (revision == null || !revision.isValid()) {
            revision = SVNRevision.HEAD;
        }
        this.getClientManager().setEventHandler((ISVNEventHandler)new SVNCommandEventProcessor(out, err, false));
        SVNCopyClient updater = this.getClientManager().getCopyClient();
        updater.doCopy(SVNURL.parseURIEncoded((String)srcURL), revision, new File(dstPath));
    }

    private void runLocalToRemote(PrintStream out, PrintStream err) throws SVNException {
        String dstURL = this.getCommandLine().getURL(0);
        String srcPath = this.getCommandLine().getPathAt(0);
        if (SVNCopyCommand.matchTabsInPath(srcPath, err) || SVNCopyCommand.matchTabsInURL(dstURL, err)) {
            return;
        }
        String message = this.getCommitMessage();
        SVNRevision revision = SVNRevision.parse((String)((String)this.getCommandLine().getArgumentValue(SVNArgument.REVISION)));
        if (revision == null || !revision.isValid()) {
            revision = SVNRevision.WORKING;
        }
        this.getClientManager().setEventHandler((ISVNEventHandler)new SVNCommandEventProcessor(out, err, false));
        SVNCopyClient updater = this.getClientManager().getCopyClient();
        SVNRevision srcRevision = SVNRevision.parse((String)((String)this.getCommandLine().getArgumentValue(SVNArgument.REVISION)));
        updater.setEventHandler(null);
        SVNCommitInfo info = updater.doCopy(new File(srcPath), srcRevision, SVNURL.parseURIEncoded((String)dstURL), message);
        if (info != SVNCommitInfo.NULL) {
            out.println();
            out.println("Committed revision " + info.getNewRevision() + ".");
        }
    }
}

