/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.command;

import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.Map;
import org.tmatesoft.svn.cli.SVNArgument;
import org.tmatesoft.svn.cli.SVNCommand;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.admin.SVNLookClient;

public class SVNLookProplistCommand
extends SVNCommand {
    public void run(PrintStream out, PrintStream err) throws SVNException {
        if (!this.getCommandLine().hasPaths()) {
            SVNCommand.println(err, "jsvnlook: Repository argument required");
            System.exit(1);
        }
        boolean isRevProp = this.getCommandLine().hasArgument(SVNArgument.REV_PROP);
        boolean isVerbose = this.getCommandLine().hasArgument(SVNArgument.VERBOSE);
        File reposRoot = new File(this.getCommandLine().getPathAt(0));
        SVNRevision revision = SVNRevision.HEAD;
        SVNLookClient lookClient = this.getClientManager().getLookClient();
        if (this.getCommandLine().hasArgument(SVNArgument.TRANSACTION)) {
            String transactionName = (String)this.getCommandLine().getArgumentValue(SVNArgument.TRANSACTION);
            Map props = null;
            if (isRevProp) {
                props = lookClient.doGetRevisionProperties(reposRoot, transactionName);
            } else {
                String path = this.getCommandLine().getPathCount() < 2 ? null : SVNPathUtil.canonicalizeAbsPath((String)this.getCommandLine().getPathAt(2));
                props = lookClient.doGetProperties(reposRoot, path, transactionName);
            }
            this.printProps(out, props, isVerbose);
            return;
        }
        if (this.getCommandLine().hasArgument(SVNArgument.REVISION)) {
            revision = SVNRevision.parse((String)((String)this.getCommandLine().getArgumentValue(SVNArgument.REVISION)));
        }
        Map props = null;
        if (isRevProp) {
            props = lookClient.doGetRevisionProperties(reposRoot, revision);
        } else {
            String path = this.getCommandLine().getPathCount() < 2 ? null : SVNPathUtil.canonicalizeAbsPath((String)this.getCommandLine().getPathAt(2));
            props = lookClient.doGetProperties(reposRoot, path, revision);
        }
        this.printProps(out, props, isVerbose);
    }

    public void run(InputStream in, PrintStream out, PrintStream err) throws SVNException {
        this.run(out, err);
    }

    public void printProps(PrintStream out, Map props, boolean isVerbose) {
        if (props != null) {
            Iterator propNames = props.keySet().iterator();
            while (propNames.hasNext()) {
                String propName = (String)propNames.next();
                if (isVerbose) {
                    String propVal = (String)props.get(propName);
                    SVNCommand.println(out, "  " + propName + " : " + propVal);
                    continue;
                }
                SVNCommand.println(out, "  " + propName);
            }
        }
    }
}

