/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.command;

import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import org.tmatesoft.svn.cli.SVNArgument;
import org.tmatesoft.svn.cli.SVNCommand;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNFormatUtil;
import org.tmatesoft.svn.core.wc.ISVNPropertyHandler;
import org.tmatesoft.svn.core.wc.SVNPropertyData;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCClient;

public class SVNPropdelCommand
extends SVNCommand {
    public void run(InputStream in, PrintStream out, PrintStream err) throws SVNException {
        this.run(out, err);
    }

    public final void run(final PrintStream out, PrintStream err) throws SVNException {
        final String propertyName = this.getCommandLine().getPathAt(0);
        boolean recursive = this.getCommandLine().hasArgument(SVNArgument.RECURSIVE);
        boolean revProp = this.getCommandLine().hasArgument(SVNArgument.REV_PROP);
        boolean force = this.getCommandLine().hasArgument(SVNArgument.FORCE);
        int pathIndex = 1;
        SVNWCClient wcClient = this.getClientManager().getWCClient();
        if (revProp) {
            SVNRevision revision = SVNRevision.UNDEFINED;
            if (this.getCommandLine().hasArgument(SVNArgument.REVISION)) {
                revision = SVNRevision.parse((String)((String)this.getCommandLine().getArgumentValue(SVNArgument.REVISION)));
            }
            if (this.getCommandLine().hasURLs()) {
                wcClient.doSetRevisionProperty(SVNURL.parseURIEncoded((String)this.getCommandLine().getURL(0)), revision, propertyName, null, force, new ISVNPropertyHandler(){

                    public void handleProperty(File path, SVNPropertyData property) throws SVNException {
                    }

                    public void handleProperty(long revision, SVNPropertyData property) throws SVNException {
                        out.println("Property '" + propertyName + "' deleted on repository revision " + revision);
                    }

                    public void handleProperty(SVNURL url, SVNPropertyData property) throws SVNException {
                    }
                });
            } else {
                File tgt = new File(".");
                if (this.getCommandLine().getPathCount() > 1) {
                    tgt = new File(this.getCommandLine().getPathAt(1));
                }
                wcClient.doSetRevisionProperty(tgt, revision, propertyName, null, force, new ISVNPropertyHandler(){

                    public void handleProperty(File path, SVNPropertyData property) throws SVNException {
                    }

                    public void handleProperty(long revision, SVNPropertyData property) throws SVNException {
                        out.println("Property '" + propertyName + "' deleted on repository revision " + revision);
                    }

                    public void handleProperty(SVNURL url, SVNPropertyData property) throws SVNException {
                    }
                });
            }
        } else {
            for (int i = pathIndex; i < this.getCommandLine().getPathCount(); ++i) {
                String absolutePath = this.getCommandLine().getPathAt(i);
                if (!recursive) {
                    wcClient.doSetProperty(new File(absolutePath), propertyName, null, force, recursive, new ISVNPropertyHandler(){

                        public void handleProperty(File path, SVNPropertyData property) throws SVNException {
                            out.println("Property '" + propertyName + "' deleted on '" + SVNFormatUtil.formatPath((File)path) + "'");
                        }

                        public void handleProperty(SVNURL url, SVNPropertyData property) throws SVNException {
                        }

                        public void handleProperty(long revision, SVNPropertyData property) throws SVNException {
                        }
                    });
                    continue;
                }
                final boolean[] wasSet = new boolean[]{false};
                wcClient.doSetProperty(new File(absolutePath), propertyName, null, force, recursive, new ISVNPropertyHandler(){

                    public void handleProperty(File path, SVNPropertyData property) throws SVNException {
                        wasSet[0] = true;
                    }

                    public void handleProperty(SVNURL url, SVNPropertyData property) throws SVNException {
                    }

                    public void handleProperty(long revision, SVNPropertyData property) throws SVNException {
                    }
                });
                if (!wasSet[0]) continue;
                out.println("Property '" + propertyName + "' deleted (recursively) on '" + absolutePath + "'");
            }
        }
    }
}

