/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.command;

import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import org.tmatesoft.svn.cli.SVNArgument;
import org.tmatesoft.svn.cli.SVNCommand;
import org.tmatesoft.svn.cli.command.SVNCommandEventProcessor;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;

public class SVNSwitchCommand
extends SVNCommand {
    public void run(InputStream in, PrintStream out, PrintStream err) throws SVNException {
        this.run(out, err);
    }

    public void run(PrintStream out, PrintStream err) throws SVNException {
        String url = this.getCommandLine().getURL(0);
        String absolutePath = this.getCommandLine().getPathCount() > 0 ? this.getCommandLine().getPathAt(0) : new File("").getAbsolutePath();
        SVNRevision revision = SVNSwitchCommand.parseRevision(this.getCommandLine());
        if (!revision.isValid()) {
            revision = SVNRevision.HEAD;
        }
        this.getClientManager().setEventHandler((ISVNEventHandler)new SVNCommandEventProcessor(out, err, false, false));
        SVNUpdateClient updater = this.getClientManager().getUpdateClient();
        try {
            SVNURL switchURL = SVNURL.parseURIEncoded((String)url);
            if (this.getCommandLine().hasArgument(SVNArgument.RELOCATE)) {
                SVNURL targetURL = SVNURL.parseURIEncoded((String)this.getCommandLine().getURL(1));
                File file = new File(absolutePath).getAbsoluteFile();
                file = new File(SVNPathUtil.validateFilePath((String)file.getAbsolutePath()));
                updater.doRelocate(file, switchURL, targetURL, !this.getCommandLine().hasArgument(SVNArgument.NON_RECURSIVE));
            } else {
                File file = new File(absolutePath).getAbsoluteFile();
                file = new File(SVNPathUtil.validateFilePath((String)file.getAbsolutePath()));
                updater.getDebugLog().info("switching path: " + file);
                updater.doSwitch(file, switchURL, revision, !this.getCommandLine().hasArgument(SVNArgument.NON_RECURSIVE));
            }
        }
        catch (Throwable th) {
            updater.getDebugLog().info(th);
            SVNSwitchCommand.println(err, th.getMessage());
            SVNSwitchCommand.println(err);
            System.exit(1);
        }
    }
}

