/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.lifecycle;

import com.opensymphony.xwork.interceptor.component.ComponentConfiguration;
import com.opensymphony.xwork.interceptor.component.ComponentManager;
import com.opensymphony.xwork.interceptor.component.DefaultComponentManager;
import java.io.Serializable;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SessionLifecycleListener
implements HttpSessionListener,
Serializable {
    private static final Log log = LogFactory.getLog((Class)(class$com$opensymphony$webwork$lifecycle$SessionLifecycleListener == null ? (class$com$opensymphony$webwork$lifecycle$SessionLifecycleListener = SessionLifecycleListener.class$("com.opensymphony.webwork.lifecycle.SessionLifecycleListener")) : class$com$opensymphony$webwork$lifecycle$SessionLifecycleListener));
    static /* synthetic */ Class class$com$opensymphony$webwork$lifecycle$SessionLifecycleListener;

    public void sessionCreated(HttpSessionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Session DefaultComponentManager : init");
        }
        HttpSession session = event.getSession();
        DefaultComponentManager container = this.createComponentManager();
        ServletContext application = this.getServletContext(session);
        ComponentManager fallback = (ComponentManager)application.getAttribute("DefaultComponentManager");
        container.setFallback(fallback);
        ComponentConfiguration config = (ComponentConfiguration)application.getAttribute("ComponentConfiguration");
        config.configure((ComponentManager)container, "session");
        session.setAttribute("DefaultComponentManager", (Object)container);
    }

    public void sessionDestroyed(HttpSessionEvent event) {
    }

    protected ServletContext getServletContext(HttpSession session) {
        return session.getServletContext();
    }

    protected DefaultComponentManager createComponentManager() {
        return new SessionComponentManager();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class SessionComponentManager
    extends DefaultComponentManager
    implements HttpSessionBindingListener {
        SessionComponentManager() {
        }

        public void valueBound(HttpSessionBindingEvent event) {
        }

        public void valueUnbound(HttpSessionBindingEvent event) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Session DefaultComponentManager : destroy");
            }
            this.dispose();
        }
    }
}

