/*
 * Decompiled with CFR 0.152.
 */
package cenqua_com_licensing.atlassian.time.chrono;

import cenqua_com_licensing.atlassian.time.DateTimeFieldType;
import cenqua_com_licensing.atlassian.time.IllegalFieldValueException;
import java.lang.ref.WeakReference;
import java.text.DateFormatSymbols;
import java.util.Locale;
import java.util.TreeMap;
import java.util.WeakHashMap;

class GJLocaleSymbols {
    private static final int FAST_CACHE_SIZE = 64;
    private static final GJLocaleSymbols[] cFastCache = new GJLocaleSymbols[64];
    private static WeakHashMap cCache = new WeakHashMap();
    private final WeakReference iLocale;
    private final String[] iEras;
    private final String[] iDaysOfWeek;
    private final String[] iShortDaysOfWeek;
    private final String[] iMonths;
    private final String[] iShortMonths;
    private final String[] iHalfday;
    private final TreeMap iParseEras;
    private final TreeMap iParseDaysOfWeek;
    private final TreeMap iParseMonths;
    private final int iMaxEraLength;
    private final int iMaxDayOfWeekLength;
    private final int iMaxShortDayOfWeekLength;
    private final int iMaxMonthLength;
    private final int iMaxShortMonthLength;
    private final int iMaxHalfdayLength;

    public static GJLocaleSymbols forLocale(Locale locale) {
        int n = System.identityHashCode(locale) & 0x3F;
        GJLocaleSymbols gJLocaleSymbols = cFastCache[n];
        if (gJLocaleSymbols != null && gJLocaleSymbols.iLocale.get() == locale) {
            return gJLocaleSymbols;
        }
        WeakHashMap weakHashMap = cCache;
        synchronized (weakHashMap) {
            gJLocaleSymbols = (GJLocaleSymbols)cCache.get(locale);
            if (gJLocaleSymbols == null) {
                gJLocaleSymbols = new GJLocaleSymbols(locale);
                cCache.put(locale, gJLocaleSymbols);
            }
        }
        GJLocaleSymbols.cFastCache[n] = gJLocaleSymbols;
        return gJLocaleSymbols;
    }

    private static String[] realignMonths(String[] stringArray) {
        String[] stringArray2 = new String[13];
        int n = 1;
        while (n < 13) {
            stringArray2[n] = stringArray[n - 1];
            ++n;
        }
        return stringArray2;
    }

    private static String[] realignDaysOfWeek(String[] stringArray) {
        String[] stringArray2 = new String[8];
        int n = 1;
        while (n < 8) {
            stringArray2[n] = stringArray[n < 7 ? n + 1 : 1];
            ++n;
        }
        return stringArray2;
    }

    private static void addSymbols(TreeMap treeMap, String[] stringArray, Integer[] integerArray) {
        int n = stringArray.length;
        while (--n >= 0) {
            String string = stringArray[n];
            if (string == null) continue;
            treeMap.put(string, integerArray[n]);
        }
    }

    private static void addNumerals(TreeMap treeMap, int n, int n2, Integer[] integerArray) {
        int n3 = n;
        while (n3 <= n2) {
            treeMap.put(String.valueOf(n3).intern(), integerArray[n3]);
            ++n3;
        }
    }

    private static int maxLength(String[] stringArray) {
        int n = 0;
        int n2 = stringArray.length;
        while (--n2 >= 0) {
            int n3;
            String string = stringArray[n2];
            if (string == null || (n3 = string.length()) <= n) continue;
            n = n3;
        }
        return n;
    }

    private GJLocaleSymbols(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        this.iLocale = new WeakReference<Locale>(locale);
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(locale);
        this.iEras = dateFormatSymbols.getEras();
        this.iDaysOfWeek = GJLocaleSymbols.realignDaysOfWeek(dateFormatSymbols.getWeekdays());
        this.iShortDaysOfWeek = GJLocaleSymbols.realignDaysOfWeek(dateFormatSymbols.getShortWeekdays());
        this.iMonths = GJLocaleSymbols.realignMonths(dateFormatSymbols.getMonths());
        this.iShortMonths = GJLocaleSymbols.realignMonths(dateFormatSymbols.getShortMonths());
        this.iHalfday = dateFormatSymbols.getAmPmStrings();
        Integer[] integerArray = new Integer[13];
        int n = 0;
        while (n < 13) {
            integerArray[n] = new Integer(n);
            ++n;
        }
        this.iParseEras = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        GJLocaleSymbols.addSymbols(this.iParseEras, this.iEras, integerArray);
        if ("en".equals(locale.getLanguage())) {
            this.iParseEras.put("BCE", integerArray[0]);
            this.iParseEras.put("CE", integerArray[1]);
        }
        this.iParseDaysOfWeek = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        GJLocaleSymbols.addSymbols(this.iParseDaysOfWeek, this.iDaysOfWeek, integerArray);
        GJLocaleSymbols.addSymbols(this.iParseDaysOfWeek, this.iShortDaysOfWeek, integerArray);
        GJLocaleSymbols.addNumerals(this.iParseDaysOfWeek, 1, 7, integerArray);
        this.iParseMonths = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        GJLocaleSymbols.addSymbols(this.iParseMonths, this.iMonths, integerArray);
        GJLocaleSymbols.addSymbols(this.iParseMonths, this.iShortMonths, integerArray);
        GJLocaleSymbols.addNumerals(this.iParseMonths, 1, 12, integerArray);
        this.iMaxEraLength = GJLocaleSymbols.maxLength(this.iEras);
        this.iMaxDayOfWeekLength = GJLocaleSymbols.maxLength(this.iDaysOfWeek);
        this.iMaxShortDayOfWeekLength = GJLocaleSymbols.maxLength(this.iShortDaysOfWeek);
        this.iMaxMonthLength = GJLocaleSymbols.maxLength(this.iMonths);
        this.iMaxShortMonthLength = GJLocaleSymbols.maxLength(this.iShortMonths);
        this.iMaxHalfdayLength = GJLocaleSymbols.maxLength(this.iHalfday);
    }

    public String eraValueToText(int n) {
        return this.iEras[n];
    }

    public int eraTextToValue(String string) {
        Integer n = (Integer)this.iParseEras.get(string);
        if (n != null) {
            return n;
        }
        throw new IllegalFieldValueException(DateTimeFieldType.era(), string);
    }

    public int getEraMaxTextLength() {
        return this.iMaxEraLength;
    }

    public String monthOfYearValueToText(int n) {
        return this.iMonths[n];
    }

    public String monthOfYearValueToShortText(int n) {
        return this.iShortMonths[n];
    }

    public int monthOfYearTextToValue(String string) {
        Integer n = (Integer)this.iParseMonths.get(string);
        if (n != null) {
            return n;
        }
        throw new IllegalFieldValueException(DateTimeFieldType.monthOfYear(), string);
    }

    public int getMonthMaxTextLength() {
        return this.iMaxMonthLength;
    }

    public int getMonthMaxShortTextLength() {
        return this.iMaxShortMonthLength;
    }

    public String dayOfWeekValueToText(int n) {
        return this.iDaysOfWeek[n];
    }

    public String dayOfWeekValueToShortText(int n) {
        return this.iShortDaysOfWeek[n];
    }

    public int dayOfWeekTextToValue(String string) {
        Integer n = (Integer)this.iParseDaysOfWeek.get(string);
        if (n != null) {
            return n;
        }
        throw new IllegalFieldValueException(DateTimeFieldType.dayOfWeek(), string);
    }

    public int getDayOfWeekMaxTextLength() {
        return this.iMaxDayOfWeekLength;
    }

    public int getDayOfWeekMaxShortTextLength() {
        return this.iMaxShortDayOfWeekLength;
    }

    public String halfdayValueToText(int n) {
        return this.iHalfday[n];
    }

    public int halfdayTextToValue(String string) {
        String[] stringArray = this.iHalfday;
        int n = stringArray.length;
        while (--n >= 0) {
            if (!stringArray[n].equalsIgnoreCase(string)) continue;
            return n;
        }
        throw new IllegalFieldValueException(DateTimeFieldType.halfdayOfDay(), string);
    }

    public int getHalfdayMaxTextLength() {
        return this.iMaxHalfdayLength;
    }
}

