/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.spi.services;

import com.atlassian.crucible.spi.PermId;
import com.atlassian.crucible.spi.data.FisheyeReviewItemData;
import com.atlassian.crucible.spi.data.GeneralCommentData;
import com.atlassian.crucible.spi.data.ReviewData;
import com.atlassian.crucible.spi.data.ReviewItemData;
import com.atlassian.crucible.spi.data.VersionedLineCommentData;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface ReviewService {
    public ReviewData createReview(ReviewData var1);

    public ReviewData createReviewFromPatch(ReviewData var1, String var2);

    public List<ReviewData> getAllReviews();

    public ReviewData getReview(PermId<ReviewData> var1);

    public List<ReviewData> getReviewsInStates(ReviewData.State[] var1);

    public Set<String> getReviewers(PermId<ReviewData> var1);

    public void addReviewer(PermId<ReviewData> var1, String var2);

    public ReviewItemData addFisheyeDiff(PermId<ReviewData> var1, String var2, String var3, String var4, String var5, String var6);

    public void removeReviewItem(PermId<ReviewData> var1, PermId<ReviewItemData> var2);

    public List<ReviewItemData> getReviewItemsForReview(PermId<ReviewData> var1);

    public VersionedLineCommentData addComment(PermId<ReviewItemData> var1, VersionedLineCommentData var2);

    public GeneralCommentData addGeneralComment(PermId<ReviewData> var1, GeneralCommentData var2);

    public List<GeneralCommentData> getGeneralComments(PermId<ReviewData> var1);

    public List<VersionedLineCommentData> getVersionedComments(PermId<ReviewItemData> var1);

    public List<VersionedLineCommentData> getAllRevisionComments(PermId<ReviewData> var1);

    public List<ReviewData> getUncompletedReviewsForUser(String var1);

    public FisheyeReviewItemData getReviewItem(PermId<ReviewData> var1, PermId<ReviewItemData> var2);

    public ReviewData changeState(PermId<ReviewData> var1, Action var2);

    public List<ReviewData> getChildReviews(PermId<ReviewData> var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Action {
        Approve("action:approveReview"),
        Delete("action:abandonReview"),
        Reject("action:rejectReview"),
        Summarize("action:summarizeReview"),
        Close("action:closeReview"),
        Reopen("action:reopenReview"),
        Recover("action:recoverReview");

        private String actionString;

        private Action(String actionString) {
            this.actionString = actionString;
        }

        public String getActionString() {
            return this.actionString;
        }
    }
}

