/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.trustedapplications;

import com.atlassian.fisheye.trustedapplications.FisheyeTrustedApplication;
import com.atlassian.fisheye.trustedapplications.FisheyeTrustedApplicationException;
import com.atlassian.security.auth.trustedapps.EncryptionProvider;
import com.atlassian.security.auth.trustedapps.IPAddressFormatException;
import com.cenqua.fisheye.util.StringUtil;
import com.cenqua.util.Base64;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrustedApplicationData {
    private static final int DEFAULT_CERT_TIMEOUT = 1000;
    private String name;
    private String id;
    private String publicKeyBase64;
    private long certificateTimeout = 1000L;
    private Set<String> urlPatterns;
    private Set<String> ipPatterns;

    public TrustedApplicationData(String name, String id, String publicKeyBase64, long certificateTimeout, Set<String> urlPatterns, Set<String> ipPatterns) {
        this.name = name;
        this.id = id;
        this.publicKeyBase64 = publicKeyBase64;
        this.certificateTimeout = certificateTimeout;
        this.urlPatterns = urlPatterns;
        this.ipPatterns = ipPatterns;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setPublicKeyBase64(String publicKeyBase64) {
        this.publicKeyBase64 = publicKeyBase64;
    }

    public void setPublicKey(PublicKey publicKey) {
        this.publicKeyBase64 = TrustedApplicationData.encodePublicKey(publicKey);
    }

    public void setCertificateTimeout(long certificateTimeout) {
        this.certificateTimeout = certificateTimeout;
    }

    public void setUrlPatternsAsString(String urlPatterns) {
        this.urlPatterns = this.split(urlPatterns);
    }

    public void setIpPatternsAsString(String ipPatterns) {
        this.ipPatterns = this.split(ipPatterns);
    }

    public TrustedApplicationData() {
    }

    public String getId() {
        return this.id;
    }

    public String getPublicKeyBase64() {
        return this.publicKeyBase64;
    }

    public long getCertificateTimeout() {
        return this.certificateTimeout;
    }

    public Set<String> getUrlPatterns() {
        return this.urlPatterns;
    }

    public Set<String> getIpPatterns() {
        return this.ipPatterns;
    }

    public String getUrlPatternsAsString() {
        return this.join(this.getUrlPatterns());
    }

    public String getIpPatternsAsString() {
        return this.join(this.getIpPatterns());
    }

    private String join(Set<String> strings) {
        String sep = "";
        StringBuilder sb = new StringBuilder();
        for (String s : strings) {
            sb.append(sep);
            sb.append(s);
            sep = ", ";
        }
        return sb.toString();
    }

    private Set<String> split(String s) {
        String[] strings = s.split(",");
        HashSet<String> set = new HashSet<String>();
        for (String string : strings) {
            String trimmed = string.trim();
            if (StringUtil.nullOrEmpty(trimmed)) continue;
            set.add(string.trim());
        }
        return set;
    }

    public String getName() {
        return this.name;
    }

    public List<Operation> getOperations() {
        return Arrays.asList(new Operation("Edit"), new Operation("Delete"));
    }

    private static String encodePublicKey(PublicKey publicKey) {
        return new String(Base64.encode(publicKey.getEncoded()));
    }

    public static TrustedApplicationData toData(FisheyeTrustedApplication type) {
        return new TrustedApplicationData(type.getName(), type.getID(), TrustedApplicationData.encodePublicKey(type.getPublicKey()), type.getCertificateTimeout(), type.getUrlPatterns(), type.getIpPatterns());
    }

    public static FisheyeTrustedApplication fromData(TrustedApplicationData data, EncryptionProvider encryptionProvider) throws FisheyeTrustedApplicationException {
        try {
            return new FisheyeTrustedApplication(data.getName(), encryptionProvider, encryptionProvider.toPublicKey(Base64.decode(data.getPublicKeyBase64())), data.getId(), data.getCertificateTimeout(), data.getUrlPatterns(), data.getIpPatterns());
        }
        catch (NoSuchAlgorithmException e2) {
            throw new FisheyeTrustedApplicationException(e2.getMessage(), e2);
        }
        catch (InvalidKeySpecException e3) {
            throw new FisheyeTrustedApplicationException(e3.getMessage(), e3);
        }
        catch (NoSuchProviderException e4) {
            throw new FisheyeTrustedApplicationException(e4.getMessage(), e4);
        }
        catch (IPAddressFormatException e5) {
            throw new FisheyeTrustedApplicationException(e5.getMessage(), e5);
        }
    }

    public class Operation {
        private String name;

        public Operation(String name) {
            this.name = name;
        }

        public String getOpName() {
            return this.name;
        }

        public String getOpParameters() {
            return "op=" + this.name + "&id=" + TrustedApplicationData.this.getId();
        }
    }
}

