/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.actions;

import com.cenqua.crucible.actions.ReviewBaseAction;
import com.cenqua.crucible.actions.SimpleAjaxResponse;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.ReviewParticipant;
import com.cenqua.crucible.model.managers.FRXManager;
import com.cenqua.crucible.model.managers.ParticipantManager;
import com.cenqua.crucible.tags.ReviewUtil;

public class CompleteFRXAjaxAction
extends ReviewBaseAction
implements SimpleAjaxResponse {
    private Integer frxId;
    private boolean complete = false;
    private String errMsg;
    private boolean worked;

    public Integer getFrxId() {
        return this.frxId;
    }

    public void setFrxId(Integer frxId) {
        this.frxId = frxId;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void setComplete(boolean complete) {
        this.complete = complete;
    }

    public String getPayload() {
        return "Not Used";
    }

    public int getValue() {
        return this.complete ? 1 : 0;
    }

    public String getErrorMsg() {
        return this.errMsg;
    }

    public boolean isWorked() {
        return this.worked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute() throws Exception {
        try {
            boolean permOK;
            this.beginTx();
            boolean bl = permOK = this.complete ? ReviewUtil.canDoReviewAction("action:completeReview", this.getReview()) : ReviewUtil.canDoReviewAction("action:uncompleteReview", this.getReview());
            if (!this.isWritable() && permOK) {
                this.commitTx();
                this.errMsg = "Sorry you are currently not authorized to change this review.";
                this.worked = false;
                String string = "error";
                return string;
            }
            if (this.frxId == null) {
                this.commitTx();
                this.errMsg = "You can't change the status of this change because there was no ID.";
                this.worked = false;
                String string = "error";
                return string;
            }
            FileRevisionExtraInfo frx = FRXManager.getById(this.frxId);
            if (frx == null) {
                this.commitTx();
                this.errMsg = "Sorry, can't find the change you are marking.";
                this.worked = false;
                String string = "error";
                return string;
            }
            ReviewParticipant p = ParticipantManager.getByUser(this.getReview(), this.getCurrentUser());
            if (p == null) {
                this.commitTx();
                this.errMsg = "Sorry, you are not a participant in this review.";
                this.worked = false;
                String string = "error";
                return string;
            }
            p.completeFrx(frx, this.complete);
            this.worked = true;
            this.commitTx();
            String string = "success";
            return string;
        }
        finally {
            this.rollbackTxIfNotCommited();
        }
    }
}

