/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.actions;

import com.cenqua.crucible.actions.ReviewBaseAction;
import com.cenqua.crucible.model.AuthorizationException;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.State;
import com.cenqua.crucible.model.managers.CommentManager;
import com.cenqua.crucible.tags.ReviewUtil;

public class StateActionAction
extends ReviewBaseAction {
    private String command;
    private String errorMsg = "error.unauthorized.stateChange.description";

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public String getError() {
        return "error.unauthorized.action";
    }

    public String getErrorDescription() {
        return this.errorMsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute() throws Exception {
        try {
            this.beginTx();
            Review review = this.getReview();
            State state = review.getState();
            if (this.command.startsWith("action:") && !ReviewUtil.canDoReviewAction(this.command, review)) {
                this.commitTx();
                String string = "AccessError";
                return string;
            }
            if (state.isReviewState() && this.command.equals("action:completeReview")) {
                if (CommentManager.countDraftComments(review, this.getCurrentUser()) == 0) {
                    review.setReviewerComplete(this.getCurrentUser());
                    review.cleanupAllComments(this.getCurrentUser());
                } else {
                    this.command = "warnDrafts";
                }
                this.commitTx();
                String string = this.command;
                return string;
            }
            if (state.isReviewState() && this.command.equals("action:uncompleteReview")) {
                review.setReviewerIncomplete(this.getCurrentUser());
                this.commitTx();
                String string = this.command;
                return string;
            }
            if (state.isReviewState() && this.command.equals("confirmCompleteDeleteDrafts")) {
                review.setReviewerComplete(this.getCurrentUser());
                review.cleanupAllComments(this.getCurrentUser());
                this.commitTx();
                String string = "action:completeReview";
                return string;
            }
            if (state.isReviewState() && this.command.equals("confirmCompletePostDrafts")) {
                CommentManager.publishDraftComments(review, this.getCurrentUser());
                review.setReviewerComplete(this.getCurrentUser());
                review.cleanupAllComments(this.getCurrentUser());
                this.commitTx();
                String string = "action:completeReview";
                return string;
            }
            if (state.isReviewState() && this.command.equals("action:summarizeReview") && (review.getCountActiveReviewers() > 0 || CommentManager.countDraftComments(review, null) > 0)) {
                this.commitTx();
                String string = "confirmSummarize";
                return string;
            }
            if (this.command.equals("confirmSummarizePostDrafts")) {
                CommentManager.publishDraftComments(review, this.getCurrentUser());
                this.command = "action:summarizeReview";
            }
            if (this.command.equals("confirmSummarizeDeleteDrafts")) {
                this.command = "action:summarizeReview";
            }
            if (this.command.equals("confirmSummarizeNoDrafts")) {
                this.command = "action:summarizeReview";
            }
            if (this.command.equals("action:approveReview") && review.getReviewers().size() == 0) {
                this.commitTx();
                String string = "confirmApprove";
                return string;
            }
            if (this.command.equals("confirmApprove")) {
                this.command = "action:approveReview";
            }
            if (this.command.equals("action:abandonReview")) {
                this.commitTx();
                String string = "confirmDelete";
                return string;
            }
            if (this.command.equals("confirmDelete")) {
                this.command = "action:abandonReview";
            }
            review.changeState(this.command, this.getCurrentUser());
            this.commitTx();
            String string = this.command;
            return string;
        }
        catch (AuthorizationException ae) {
            this.errorMsg = ae.getMessage();
            String string = "AccessError";
            return string;
        }
        finally {
            this.rollbackTxIfNotCommited();
        }
    }
}

