/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.actions.admin.project;

import com.atlassian.crucible.spi.impl.Utils;
import com.cenqua.crucible.actions.admin.project.ProjectData;
import com.cenqua.crucible.actions.admin.project.UserData;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.managers.PermissionManager;
import com.cenqua.crucible.model.managers.ProjectKeyException;
import com.cenqua.crucible.model.managers.ProjectManager;
import java.util.HashSet;
import org.springframework.stereotype.Component;

@Component(value="projectDataFactory")
public class ProjectDataFactory {
    public ProjectData createFromProject(Project p) {
        return new ProjectData(p.getId() == null ? 0 : p.getId(), p.getName(), p.getKey(), Utils.crucibleUsersToUserDataSet(p.getDefaultReviewerUsers()), new HashSet<String>(p.getDefaultReviewerGroups()), Utils.crucibleUsersToUserDataSet(p.getAllowedReviewerUsers()), new HashSet<String>(p.getAllowedReviewerGroups()), Utils.crucibleUserToUserData(p.getDefaultModerator()), p.getDefaultRepositoryName(), p.getPermissionScheme() == null ? null : p.getPermissionScheme().getName(), p.isAllowReviewersToJoin());
    }

    public void updateProject(ProjectManager projectManager, ProjectData projectData) throws ProjectKeyException {
        if (projectData.getId() < 1) {
            throw new IllegalArgumentException("ID must be a positive integer.");
        }
        Project p = projectManager.getProjectById(projectData.getId());
        if (p == null) {
            throw new IllegalArgumentException("Project " + projectData.getId() + " does not exist.");
        }
        if (!p.getKey().equals(projectData.getKey())) {
            if (projectManager.getProjectByKey(projectData.getKey()) != null) {
                throw new ProjectKeyException();
            }
            projectManager.changeProjectKey(p, projectData.getKey());
        }
        p.setAllowReviewersToJoin(projectData.isAllowReviewersToJoin());
        UserData defaultModerator = projectData.getDefaultModerator();
        if (defaultModerator != null) {
            p.setDefaultModerator(Utils.getUserByName(defaultModerator.getUserName()));
        } else {
            p.setDefaultModerator(null);
        }
        p.setDefaultRepositoryName(projectData.getDefaultRepositoryName());
        p.setDefaultReviewerUsers(Utils.userDataCollectionToCrucibleUserSet(projectData.getDefaultReviewerUsers()));
        p.setDefaultReviewerGroups(projectData.getDefaultReviewerGroups());
        p.setAllowedReviewerUsers(Utils.userDataCollectionToCrucibleUserSet(projectData.getAllowedReviewerUsers()));
        p.setAllowedReviewerGroups(projectData.getAllowedReviewerGroups());
        p.setKey(projectData.getKey());
        p.setName(projectData.getName());
        p.setPermissionScheme(PermissionManager.findPS(projectData.getPermissionSchemeName()));
    }
}

