/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.actions.comment;

import com.cenqua.crucible.actions.SimpleAjaxResponse;
import com.cenqua.crucible.actions.comment.BaseCommentAction;
import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.managers.CommentManager;
import com.cenqua.crucible.model.managers.LogManager;

public class DeleteCommentAjaxAction
extends BaseCommentAction
implements SimpleAjaxResponse {
    private Integer commentId;
    private int commentCount = 0;

    public Integer getCommentId() {
        return this.commentId;
    }

    public void setCommentId(Integer commentId) {
        this.commentId = commentId;
    }

    public String getPayload() {
        return "Not Used";
    }

    public int getValue() {
        return this.commentCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute() throws Exception {
        try {
            this.beginTx();
            if (!this.isAllowed()) {
                this.commitTx();
                this.setErrorMsg("Sorry you're not authorized to delete a comment from this review now.");
                String string = "error";
                return string;
            }
            if (this.commentId == null) {
                this.commitTx();
                this.setErrorMsg("This comment can't be deleted because there was no comment ID.");
                String string = "error";
                return string;
            }
            Comment comment = CommentManager.getById(this.commentId);
            if (comment == null) {
                this.commitTx();
                this.setErrorMsg("Sorry comment " + this.commentId + " doesn't exist.");
                String string = "error";
                return string;
            }
            if (comment.getCommentCount() != 0) {
                this.commitTx();
                this.setErrorMsg("This comment can't be deleted because there are replies.");
                String string = "error";
                return string;
            }
            if (comment.getUser().equals(this.getCurrentUser())) {
                comment.setDeleted(true);
                if (!comment.isDraft()) {
                    LogManager.log(comment.getReview().getPermaId() + ": " + comment.getUser().getUserName() + " deleted comment " + comment.getId() + ": " + comment.getMessage());
                }
            }
            this.commentCount = comment.getReview().getCountAllCommentsInReview();
            this.commitTx();
            String string = "success";
            return string;
        }
        finally {
            this.rollbackTxIfNotCommited();
        }
    }
}

