/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.actions.comment;

import com.cenqua.crucible.actions.SimpleAjaxResponse;
import com.cenqua.crucible.actions.comment.BaseCommentAction;
import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.managers.CommentManager;

public class PublishCommentAjaxAction
extends BaseCommentAction
implements SimpleAjaxResponse {
    private Integer commentId;
    private int commentCount;

    public Integer getCommentId() {
        return this.commentId;
    }

    public void setCommentId(Integer commentId) {
        this.commentId = commentId;
    }

    public String getPayload() {
        return "Not Used";
    }

    public int getValue() {
        return this.commentCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute() throws Exception {
        try {
            this.beginTx();
            if (!this.isAllowed()) {
                this.commitTx();
                this.setErrorMsg("Sorry you're not authorized to post a comment to this review now.");
                String string = "error";
                return string;
            }
            if (this.commentId == null) {
                this.commitTx();
                this.setErrorMsg("Your comment can't be posted because there was no comment ID");
                String string = "error";
                return string;
            }
            Comment comment = CommentManager.getById(this.commentId);
            if (comment == null) {
                this.commitTx();
                this.setErrorMsg("Your comment can't be posted because it no longer exists.");
                String string = "error";
                return string;
            }
            if (comment.getUser().equals(this.getCurrentUser())) {
                CommentManager.publishComment(comment);
            }
            this.commentCount = comment.getReview().getCountAllCommentsInReview();
            this.commitTx();
            String string = "success";
            return string;
        }
        finally {
            this.rollbackTxIfNotCommited();
        }
    }
}

