/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model;

import com.cenqua.crucible.filters.CrucibleFilter;
import com.cenqua.crucible.model.FileRevisionException;
import com.cenqua.crucible.revision.FileInfo;
import com.cenqua.crucible.revision.source.Source;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.RevInfoKey;
import java.util.Date;

public class FileRevision {
    private Integer id;
    private String source;
    private String path;
    private String reviewResult = "unset";
    private String revisionName;
    private String revIdent;
    private Date createDate;

    public FileRevision() {
        this.setCreateDate(new Date());
    }

    public FileRevision(String source, String path, String revIdent, String revName, Date createDate) {
        this.setSourceName(source);
        this.setPath(path);
        this.setRevisionName(revName);
        this.setRevIdent(revIdent);
        this.setCreateDate(createDate);
    }

    public String getCsId() {
        return this.getSource().getChangeSetId(this);
    }

    public String getLatestRevIdent() {
        return this.getSource().getLatestRevIdent(this);
    }

    public boolean isAnySuccessorRevisions() {
        return this.getSource().isAnySuccessorRevisions(this);
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public String getRevisionName() {
        return this.revisionName;
    }

    public void setRevisionName(String revision) {
        this.revisionName = revision;
    }

    public String getRevIdent() {
        return this.revIdent;
    }

    public void setRevIdent(String revIdent) {
        this.revIdent = revIdent;
    }

    public String getSourceName() {
        return this.source;
    }

    public void setSourceName(String source) {
        this.source = source;
    }

    public Source getSource() {
        return CrucibleFilter.getSource(this.getSourceName());
    }

    public FileInfo getFileInfo() throws FileRevisionException {
        return this.getSource().getFileInfo(this);
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Path getFePath() {
        return new Path(this.path);
    }

    public RevInfoKey getRevInfoKey() {
        return new RevInfoKey(this.getFePath(), this.getRevIdent());
    }

    public String getFileName() {
        return this.getFePath().getName();
    }

    public String getReviewResult() {
        return this.reviewResult;
    }

    public void setReviewResult(String reviewResult) {
        this.reviewResult = reviewResult;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (this.id == null) {
            return false;
        }
        if (o == null || !(o instanceof FileRevision)) {
            return false;
        }
        Integer oid = ((FileRevision)o).getId();
        return oid != null && this.id.equals(oid);
    }

    public int hashCode() {
        return this.id == null ? 0 : this.id.hashCode();
    }
}

