/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model;

import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.CrucibleUser;
import com.cenqua.crucible.model.FileRevision;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.RevisionComment;
import com.cenqua.crucible.model.managers.CommentManager;
import com.cenqua.crucible.model.managers.RevisionCommentManager;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileRevisionExtraInfo {
    public static final String PERMAID_PREFIX = "CFR-";
    public static final int SCOPE_REVIEW_ALL = 0;
    public static final int SCOPE_REVIEW_CHANGES = 1;
    public static final int REVIEWED_NOT = -1;
    public static final int REVIEWED_ALL = 0;
    public static final int REVIEWED_CHANGES = 1;
    public static final int FURTHER_ACTION_NO = 0;
    public static final int FURTHER_ACTION_YES = 1;
    public static final int FURTHER_ACTION_COMPLETED = 2;
    private Integer id;
    private Review review;
    private FileRevision fileRevision;
    private FileRevision fromRevision;
    private Date whenAdded;
    private Integer reviewed = new Integer(-1);
    private Integer furtherAction = new Integer(0);
    private Integer reviewScope = new Integer(0);
    private Set<RevisionComment> revisionComments = new HashSet<RevisionComment>();

    public FileRevisionExtraInfo() {
    }

    public FileRevisionExtraInfo(Review review, FileRevision fr, Date whenAdded) {
        this.fileRevision = fr;
        this.review = review;
        this.whenAdded = whenAdded;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getPermaId() {
        return PERMAID_PREFIX + this.id;
    }

    public static Integer getIdFromPermaId(String permaId) {
        if (permaId == null || !permaId.startsWith(PERMAID_PREFIX)) {
            return null;
        }
        try {
            return new Integer(permaId.substring(PERMAID_PREFIX.length()));
        }
        catch (NumberFormatException e2) {
            return null;
        }
    }

    public Review getReview() {
        return this.review;
    }

    public void setReview(Review review) {
        this.review = review;
    }

    public FileRevision getFileRevision() {
        return this.fileRevision;
    }

    public void setFileRevision(FileRevision fileRevision) {
        this.fileRevision = fileRevision;
    }

    public Set<RevisionComment> getRevisionComments() {
        return this.revisionComments;
    }

    public Collection<CommentManager.CommentPair> getCommentPairs() {
        return CommentManager.createCommentPairs(this.revisionComments);
    }

    public void setRevisionComments(Set<RevisionComment> revisionComments) {
        this.revisionComments = revisionComments;
    }

    public void addRevisionComment(RevisionComment revisionComment) {
        this.revisionComments.add(revisionComment);
    }

    public void removeRevisionComment(RevisionComment revisionComment) {
        this.revisionComments.remove(revisionComment);
    }

    public Date getWhenAdded() {
        return this.whenAdded;
    }

    public void setWhenAdded(Date whenAdded) {
        this.whenAdded = whenAdded;
    }

    public Integer getReviewed() {
        return this.reviewed;
    }

    public void setReviewed(Integer reviewed) {
        this.reviewed = reviewed;
    }

    public Integer getFurtherAction() {
        return this.furtherAction;
    }

    public void setFurtherAction(Integer furtherAction) {
        this.furtherAction = furtherAction;
    }

    public Integer getReviewScope() {
        return this.reviewScope;
    }

    public void setReviewScope(Integer reviewScope) {
        this.reviewScope = reviewScope;
    }

    public FileRevision getFromRevision() {
        return this.fromRevision;
    }

    public void setFromRevision(FileRevision fromRevision) {
        this.fromRevision = fromRevision;
    }

    public void cleanUpRevisionComments() {
        this.cleanUpRevisionComments(null);
    }

    public void cleanUpRevisionComments(CrucibleUser user) {
        HashSet<RevisionComment> removeThese = new HashSet<RevisionComment>();
        for (RevisionComment rc : this.revisionComments) {
            rc.getComment().cleanUpComments();
            if (user != null && !rc.getComment().getUser().equals(user) || !rc.isDeleted() && !rc.isDraft()) continue;
            removeThese.add(rc);
        }
        this.removeComments(removeThese);
    }

    private void removeComments(Set<RevisionComment> removeThese) {
        for (RevisionComment rc : removeThese) {
            Comment comment = rc.getComment();
            this.removeRevisionComment(rc);
            RevisionCommentManager.deleteRevisionComment(rc);
            CommentManager.deleteComment(comment);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (this.id == null) {
            return false;
        }
        if (o == null || !(o instanceof FileRevisionExtraInfo)) {
            return false;
        }
        Integer oid = ((FileRevisionExtraInfo)o).getId();
        return oid != null && this.id.equals(oid);
    }

    public int hashCode() {
        return this.id == null ? 0 : this.id.hashCode();
    }
}

