/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.notification;

import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.CrucibleUser;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.Role;
import com.cenqua.crucible.model.managers.CommentManager;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.notification.Notification;
import com.cenqua.crucible.notification.NotificationManager;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.logging.Logs;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public class CommentNotification
extends Notification {
    private Comment comment;
    private static final String COMMENT_NOTE_TEMPLATE = "comment-notification.ftl";

    public CommentNotification() {
    }

    public CommentNotification(Review review, Comment comment) {
        super(comment.getUser());
        this.setComment(comment);
        this.setReview(review);
    }

    protected Integer getType() {
        return NotificationManager.TYPE_COMMENTED;
    }

    public Comment getComment() {
        if (this.comment == null) {
            this.comment = CommentManager.getById(this.getRef1());
            if (this.comment == null) {
                Logs.APP_LOG.warn((Object)("Comment " + this.getRef1() + "doesn't exist."));
            }
        }
        return this.comment;
    }

    public void setComment(Comment comment) {
        this.comment = comment;
        this.setRef1(comment.getId());
    }

    public String getLink() {
        return AppConfig.getsConfig().getSiteURL() + "cru/" + this.getReview().getPermaId() + (this.getComment() != null ? "#c" + this.getComment().getId() : "");
    }

    protected String getEmailTemplateName() {
        return COMMENT_NOTE_TEMPLATE;
    }

    public String getRSSNote() throws IOException, TemplateException {
        return this.getEmailNote();
    }

    public String getRSSTitle() {
        Comment comment = this.getComment();
        if (comment == null) {
            return "Comment deleted";
        }
        return this.getReview().getPermaId() + ":" + this.getComment().getUser().getDisplayName() + (this.getComment().isDefectRaised() ? " raised a defect" : " commented");
    }

    public String getDescription() {
        return "Comment";
    }

    public List getRolesToNotify() {
        LinkedList<Role> roles = new LinkedList<Role>();
        roles.add(ReviewManager.AUTHOR);
        roles.add(ReviewManager.MODERATOR);
        roles.add(ReviewManager.REVIEWER);
        return roles;
    }

    public Integer getEmailNotificationPref(CrucibleUser user) {
        return user.getCommentEmailNotification();
    }

    public Integer getRssNotificationPref(CrucibleUser user) {
        return user.getCompleteEmailNotification();
    }
}

