/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.notification;

import com.cenqua.crucible.model.CrucibleUser;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.Role;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.notification.Notification;
import com.cenqua.fisheye.AppConfig;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public abstract class UserCompletionStatusNotification
extends Notification {
    public UserCompletionStatusNotification() {
    }

    public UserCompletionStatusNotification(CrucibleUser actioner, Review review) {
        super(actioner);
        this.setReview(review);
    }

    public String getLink() {
        return AppConfig.getsConfig().getSiteURL() + "cru/" + this.getReview().getPermaId();
    }

    public String getRSSNote() throws IOException, TemplateException {
        return this.getEmailNote();
    }

    public List getRolesToNotify() {
        LinkedList<Role> roles = new LinkedList<Role>();
        roles.add(ReviewManager.AUTHOR);
        roles.add(ReviewManager.MODERATOR);
        return roles;
    }

    public Integer getEmailNotificationPref(CrucibleUser user) {
        return user.getCompleteEmailNotification();
    }

    public Integer getRssNotificationPref(CrucibleUser user) {
        return user.getCompleteEmailNotification();
    }
}

