/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.revision.diff.patchDiff;

import com.cenqua.crucible.revision.diff.DefaultUnifiedDiffListener;
import com.cenqua.fisheye.Path;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatchDiffListener
extends DefaultUnifiedDiffListener {
    private LinkedList<Sect> sects = new LinkedList();
    private Sect currentSect;
    private int currentFromLineNo;
    private int currentToLineNo;
    private String fromTimeStamp;
    private String toTimeStamp;
    private String fromPath = "";
    private String toPath = "";

    public List<Sect> getSects() {
        return this.sects;
    }

    public String getFromPath() {
        return this.fromPath;
    }

    public String getToPath() {
        return this.toPath;
    }

    public String getFromTimeStamp() {
        return this.fromTimeStamp;
    }

    public String getToTimeStamp() {
        return this.toTimeStamp;
    }

    @Override
    public void fromFile(Path path) {
        this.fromPath = path.getPath();
    }

    @Override
    public void toFile(Path path) {
        this.toPath = path.getPath();
    }

    @Override
    public void section(int fromLine, int numFromLines, int toLine, int numToLines) {
        this.currentSect = null;
        this.currentFromLineNo = fromLine - 1;
        this.currentToLineNo = toLine - 1;
    }

    private boolean isGap() {
        return this.currentSect == null && this.sects.size() != 0;
    }

    @Override
    public void addLine(String line) {
        if (this.currentSect == null || this.currentSect.common) {
            this.currentSect = new Sect(false, this.isGap());
            this.sects.add(this.currentSect);
        }
        this.currentSect.addLine(line, this.currentToLineNo++, this.currentFromLineNo, true);
    }

    @Override
    public void contextLine(String line) {
        if (this.currentSect == null || !this.currentSect.common) {
            this.currentSect = new Sect(true, this.isGap());
            this.sects.add(this.currentSect);
        }
        this.currentSect.addLine(line, this.currentToLineNo++, this.currentFromLineNo++, false);
    }

    @Override
    public void removeLine(String line) {
        if (this.currentSect == null || this.currentSect.common) {
            this.currentSect = new Sect(false, this.isGap());
            this.sects.add(this.currentSect);
        }
        this.currentSect.addLine(line, this.currentToLineNo, this.currentFromLineNo++, false);
    }

    @Override
    public void fromTimeStamp(String date) {
        this.fromTimeStamp = date;
    }

    @Override
    public void toTimeStamp(String date) {
        this.toTimeStamp = date;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Sect {
        private LinkedList<Line> fromLines = new LinkedList();
        private LinkedList<Line> toLines = new LinkedList();
        private boolean common = false;
        private int toChars = 0;
        private int fromChars = 0;
        private boolean gap = false;

        public Sect(boolean common, boolean gap) {
            this.common = common;
            this.gap = gap;
        }

        public void addLine(String text, int toNumber, int fromNumber, boolean toLine) {
            if (toLine || this.common) {
                this.toLines.add(new Line(text, toNumber, this.toChars));
                this.toChars += text.length();
            }
            if (!toLine || this.common) {
                this.fromLines.add(new Line(text, fromNumber, this.fromChars));
                this.fromChars += text.length();
            }
        }

        public int getFirstFromLineNumber() {
            return this.fromLines.size() == 0 ? 0 : this.fromLines.getFirst().number;
        }

        public int getFirstToLineNumber() {
            return this.toLines.size() == 0 ? 0 : this.toLines.getFirst().number;
        }

        public int getFromLinesCount() {
            return this.fromLines.size();
        }

        public int getToLinesCount() {
            return this.toLines.size();
        }

        public boolean isCommon() {
            return this.common;
        }

        public boolean isGap() {
            return this.gap;
        }

        public int getFromLineOffset(int i2) {
            return this.getLineOffset(this.getFirstFromLineNumber(), this.fromLines, i2);
        }

        public StringBuffer getFromLine(int i2) {
            return new StringBuffer(this.fromLines.get((int)(i2 - this.getFirstFromLineNumber())).text);
        }

        public int getToLineOffset(int i2) {
            return this.getLineOffset(this.getFirstToLineNumber(), this.toLines, i2);
        }

        private int getLineOffset(int startLine, LinkedList<Line> lines, int line) {
            int index = line - startLine;
            if (lines.size() == 0) {
                return 0;
            }
            if (index == lines.size()) {
                return lines.getLast().offset + lines.getLast().text.length();
            }
            if (index < lines.size()) {
                return lines.get((int)index).offset;
            }
            throw new IndexOutOfBoundsException("Requested line " + line + " from set starting at " + startLine + " with size " + lines.size());
        }

        public StringBuilder getToLine(int i2) {
            return new StringBuilder(this.toLines.get((int)(i2 - this.getFirstToLineNumber())).text);
        }

        public StringBuilder getFromLines() {
            return this.getLines(this.fromLines);
        }

        public StringBuilder getToLines() {
            return this.getLines(this.toLines);
        }

        private StringBuilder getLines(List<Line> lines) {
            StringBuilder buf = new StringBuilder();
            for (Line line : lines) {
                buf.append(line.text);
            }
            return buf;
        }

        static class Line {
            String text;
            int number;
            int offset;

            public Line(String text, int number, int offset) {
                this.text = text;
                this.number = number;
                this.offset = offset;
            }
        }
    }
}

