/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.tags;

import com.cenqua.crucible.filters.CrucibleFilter;
import com.cenqua.crucible.model.CrucibleUser;
import com.cenqua.crucible.model.FileRevision;
import com.cenqua.crucible.model.PermissionScheme;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.StateTransition;
import com.cenqua.crucible.model.managers.GroupManager;
import com.cenqua.crucible.model.managers.ParticipantManager;
import com.cenqua.crucible.model.managers.PermissionManager;
import com.cenqua.crucible.model.managers.ProjectManager;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.reports.Period;
import com.cenqua.crucible.tags.MaybeReview;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.user.UserManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReviewUtil {
    public static List getStateActions(Review review) {
        LinkedList<StateTransition> allowedTrans = new LinkedList<StateTransition>();
        List<StateTransition> trans = review.getState().getStateProgressionActions();
        StateTransition sendToMod = null;
        boolean approveIncluded = false;
        for (StateTransition t : trans) {
            if (!ReviewUtil.canDoReviewAction(t.getActionName(), review)) continue;
            if (t.getActionName().equals("action:submitReview")) {
                sendToMod = t;
            }
            if (t.getActionName().equals("action:approveReview")) {
                approveIncluded = true;
            }
            allowedTrans.add(t);
        }
        if (approveIncluded && sendToMod != null) {
            allowedTrans.remove(sendToMod);
        }
        return allowedTrans;
    }

    public static boolean isShowComplete(Review review, CrucibleUser user) {
        return ReviewUtil.canDoReviewAction("action:completeReview", review) && user != null && review.checkActiveReviewer(user) && review.getState().isReviewState();
    }

    public static boolean isShowUncomplete(Review review, CrucibleUser user) {
        return ReviewUtil.canDoReviewAction("action:uncompleteReview", review) && user != null && review.checkCompletedReviewer(user) && review.getState().isReviewState();
    }

    public static boolean isShowJoinReview(Review review, CrucibleUser user) throws DbException {
        return review.isAllowReviewerToJoin() && !ReviewUtil.isParticipant(review, user) && (review.getProject().getAllowedReviewers().contains(user) || review.getProject().getAllowedReviewers().isEmpty());
    }

    public static boolean isParticipant(Review review, CrucibleUser user) {
        return ParticipantManager.getByUser(review, user) != null;
    }

    public static boolean isInReview(Review review, FileRevision fr) {
        return review.getAllReviewFileRevisions().contains(fr);
    }

    public static boolean principalCanDoReviewAction(Principal p, String actionName, Review review) {
        PermissionScheme ps = review.getProject().getPermissionScheme();
        return PermissionManager.canPrincipalDoAction(ps, p, actionName, ReviewUtil.makeGroupManager(), review);
    }

    public static boolean principalCanDoProjectAction(Principal p, String actionName, Project project) {
        PermissionScheme ps = project.getPermissionScheme();
        return PermissionManager.canPrincipalDoAction(ps, p, actionName, ReviewUtil.makeGroupManager(), null);
    }

    private static GroupManager makeGroupManager() {
        return new GroupManager(){

            @Override
            public List<String> getPrincipalGroups(Principal p) throws DbException {
                UserManager feum = AppConfig.getsConfig().getUserManager();
                return feum.getGroupsForUser(p.getUserName());
            }
        };
    }

    public static boolean canDoReviewAction(String actionName, Review review) {
        return ReviewUtil.principalCanDoReviewAction(CrucibleFilter.getCurrentPrincipal(), actionName, review);
    }

    public static MaybeReview getSecuredReviewById(Integer id) {
        Review r = ReviewManager.getReviewById(id);
        if (r == null) {
            Logs.APP_LOG.warn((Object)("Review with ID " + id + "not found while getting Review by ID"));
            return new MaybeReview(r, false);
        }
        return new MaybeReview(r, ReviewUtil.canDoReviewAction("action:viewReview", r));
    }

    public static List<MaybeReview> getSecuredUndeadReviewsById(Collection<Integer> ids) {
        ArrayList<MaybeReview> reviews = new ArrayList<MaybeReview>();
        for (Integer id : ids) {
            MaybeReview mr = ReviewUtil.getSecuredReviewById(id);
            if (mr.getReview() == null || mr.getReview().getState().isTrashMetaState()) continue;
            reviews.add(mr);
        }
        return reviews;
    }

    public static boolean principalCanDoAction(Principal p, String actionName) {
        return PermissionManager.canPrincipalDoActionInAnyProject(p, actionName, ReviewUtil.makeGroupManager());
    }

    public static boolean canDoAction(String actionName) {
        return ReviewUtil.principalCanDoAction(CrucibleFilter.getCurrentPrincipal(), actionName);
    }

    public static String getProjectKey(String projectKey) {
        ProjectManager projectManager;
        Project p;
        if (StringUtils.isNotBlank((String)projectKey) && (p = (projectManager = (ProjectManager)SpringContext.getComponent("projectManager")).getProjectByKey(projectKey)) != null && ReviewUtil.principalCanDoProjectAction(CrucibleFilter.getCurrentPrincipal(), "action:createReview", p)) {
            return "?projectKey=" + projectKey;
        }
        return "";
    }

    public static Object valueOrDefault(Object value, Object defaultVal) {
        return value == null ? defaultVal : value;
    }

    public static Period makePeriod(int count, String units) {
        int u = Period.DAYS;
        char firstLetter = units.toLowerCase().charAt(0);
        switch (firstLetter) {
            case 'h': {
                u = Period.HOURS;
                break;
            }
            case 'd': {
                u = Period.DAYS;
                break;
            }
            case 'w': {
                u = Period.WEEKS;
                break;
            }
            case 'm': {
                u = Period.MONTHS;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown unit: " + units + "use hours, days, weeks, months");
            }
        }
        Period p = new Period();
        p.tMinus(count, u);
        return p;
    }
}

