/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.view;

import com.cenqua.crucible.filters.CrucibleFilter;
import com.cenqua.crucible.model.FileRevision;
import com.cenqua.crucible.model.FileRevisionException;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.FRXManager;
import com.cenqua.crucible.revision.source.RepositorySource;
import com.cenqua.crucible.revision.source.Source;
import com.cenqua.crucible.revision.source.SourceException;
import com.cenqua.crucible.util.FileRevisionToReviewMapper;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileHistory;
import com.cenqua.fisheye.util.MultiMap;
import com.cenqua.fisheye.web.FileHistoryExplorer;
import com.cenqua.fisheye.web.WaybackSpec;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class RevInfoDO {
    private final Review review;
    private final String sourceName;
    private final RepositorySource source;
    private final Path path;
    private final WaybackSpec wb;
    private com.cenqua.fisheye.rep.FileRevision selectedRev;
    private boolean inThisReview = false;
    private TIntArrayList feFrsInReview = new TIntArrayList();
    private Map branchMap;

    public RevInfoDO(Review review, String sourceName, Path path, WaybackSpec wb) {
        this.review = review;
        this.sourceName = sourceName;
        this.path = path;
        this.wb = wb;
        Source s = CrucibleFilter.getSource(sourceName);
        if (s instanceof RepositorySource && s.isAvailable()) {
            this.source = (RepositorySource)s;
            this.processFileRevisions(review);
        } else {
            this.source = null;
            Logs.APP_LOG.error((Object)s.getReason());
            this.branchMap = Collections.EMPTY_MAP;
        }
    }

    private void processFileRevisions(Review review) {
        List<FileRevision> cruFrsInReview = review.getFileRevisions();
        for (FileRevision fr : cruFrsInReview) {
            if (!fr.getSource().equals(this.source)) continue;
            try {
                this.feFrsInReview.add(fr.getFileInfo().getRevID());
            }
            catch (FileRevisionException e2) {
                Logs.APP_LOG.warn((Object)("RevInfoDO Ignoring " + fr.getRevIdent() + " reason " + e2.getMessage()));
            }
        }
        try {
            this.branchMap = this.annotateFileHistory();
        }
        catch (Exception e3) {
            Logs.APP_LOG.error((Object)"Problem getting previous revisions", (Throwable)e3);
            this.branchMap = Collections.EMPTY_MAP;
        }
    }

    public boolean isInThisReview() {
        return this.inThisReview;
    }

    public com.cenqua.fisheye.rep.FileRevision getSelectedRev() {
        return this.selectedRev;
    }

    public Map getBranchMap() {
        return this.branchMap;
    }

    public Collection getBranches() {
        return this.branchMap.keySet();
    }

    private Map annotateFileHistory() throws DbException, FileRevisionException, SourceException {
        List<FileRevisionExtraInfo> frxs;
        if (!this.source.isAvailable()) {
            throw this.source.getException();
        }
        FileHistory fh = this.source.getRepoEngine().getRevisionCache().getFullFileHistory(this.path);
        FileHistoryExplorer fhe = new FileHistoryExplorer(fh, this.wb);
        List branches = fhe.getBranchRevisions();
        FileRevisionToReviewMapper finder = new FileRevisionToReviewMapper(this.sourceName);
        MultiMap<String, RepositorySource.AncestorAnnotationDO> result = new MultiMap<String, RepositorySource.AncestorAnnotationDO>(new LinkedHashMap());
        for (String br : branches) {
            List revs = (List)fhe.getInfoMap().get(br);
            for (com.cenqua.fisheye.rep.FileRevision fr : revs) {
                Collection reviews = finder.findReviewsForRevision(fr.getRevInfoKey());
                if (reviews.isEmpty()) {
                    result.add(br, new RepositorySource.AncestorAnnotationDO(fr, this.currentlySelected(fr)));
                    continue;
                }
                result.add(br, new RepositorySource.AncestorAnnotationDO(fr, this.currentlySelected(fr), new ArrayList(reviews)));
            }
        }
        if (this.selectedRev == null && (frxs = FRXManager.getFRExtraInfos(this.path.getPath(), this.review)).size() > 0) {
            FileRevisionExtraInfo frx = frxs.get(0);
            FileRevision crufr = frx.getFileRevision();
            this.inThisReview = true;
            this.selectedRev = this.source.getFeFileRevision(crufr);
            String br = this.selectedRev.getBranch();
            if (!result.keySet().contains(br)) {
                branches.add(0, br);
            }
            result.add(br, new RepositorySource.AncestorAnnotationDO(this.selectedRev, true, new ArrayList(finder.findReviewsForRevision(this.selectedRev.getRevInfoKey()))));
        }
        return result.map();
    }

    private boolean currentlySelected(com.cenqua.fisheye.rep.FileRevision fr) {
        boolean sel = this.feFrsInReview.contains(fr.getRevID());
        if (sel) {
            this.inThisReview = true;
            this.selectedRev = fr;
        }
        return sel;
    }
}

