/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.bucket;

import com.cenqua.fisheye.bucket.BucketData;
import com.cenqua.fisheye.bucket.BucketDataCollection;
import com.cenqua.fisheye.bucket.BucketDataElement;
import com.cenqua.fisheye.bucket.CalculatedBucketGraph;
import com.cenqua.fisheye.bucket.InvalidBucketException;
import com.cenqua.fisheye.bucket.Period;
import com.cenqua.fisheye.bucket.PeriodUnit;
import com.cenqua.fisheye.bucket.RenamingRules;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.util.Pair;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import org.jfree.data.time.TimePeriodValues;
import org.jfree.data.time.TimePeriodValuesCollection;
import org.jfree.data.xy.CategoryTableXYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalculatedBucketGraphXY
extends CalculatedBucketGraph {
    private static final int DEFAULT_MAX_ELEMENTS = 10;
    private static final int GRAPH_BORDER_WIDTH = 30;
    private static final int MAX_BAR_WIDTH_MINICHART = 3;
    private static final int MAX_BAR_WIDTH_CHARTPAGE = 5;
    private final XYSeriesCollection collectionLinecount = new XYSeriesCollection();
    private final TimePeriodValuesCollection collectionRevcount = new TimePeriodValuesCollection();
    private final Date dateStart;
    private final Date dateEnd;
    private final boolean showLegend;

    public CalculatedBucketGraphXY() {
        this.showLegend = false;
        this.dateStart = new Date(0L);
        this.dateEnd = new Date();
    }

    public CalculatedBucketGraphXY(TimeZone timeZone, BucketDataCollection bucketsAll, boolean trunkLike, PeriodUnit periodSlurp, int width, Date date1, Date date2, String repname, boolean isMiniChart, boolean isBreakdownNone, Integer maxItemsInChart, RenamingRules renameRules) throws DbException {
        PeriodUnit periodGraph;
        if (maxItemsInChart == null) {
            maxItemsInChart = 10;
        }
        this.showLegend = !isMiniChart && !isBreakdownNone;
        Pair<Date, Date> dates = null;
        try {
            dates = CalculatedBucketGraphXY.calculateDates(date1, date2, bucketsAll.getFirstBucket(), bucketsAll.getLastBucket(), periodSlurp, timeZone);
        }
        catch (InvalidBucketException e2) {
            e2.printStackTrace();
        }
        if (dates == null) {
            this.dateStart = new Date(0L);
            this.dateEnd = new Date();
            periodGraph = PeriodUnit.YEAR;
        } else {
            this.dateStart = (Date)dates.getFirst();
            this.dateEnd = dates.getSecond();
            periodGraph = CalculatedBucketGraphXY.choosePeriod(width, this.dateStart, this.dateEnd, isMiniChart);
        }
        this.constructXYSeries(bucketsAll, trunkLike, periodSlurp, periodGraph, repname, maxItemsInChart, timeZone, renameRules);
    }

    public CalculatedBucketGraphXY(TimeZone timeZone, BucketDataCollection bucketsAll, boolean trunkLike, PeriodUnit periodSlurp, PeriodUnit periodGraph, String repname, Integer maxElements, RenamingRules renameRules) throws DbException {
        if (maxElements == null) {
            maxElements = 10;
        }
        this.showLegend = false;
        this.dateStart = new Date(0L);
        this.dateEnd = new Date();
        this.constructXYSeries(bucketsAll, trunkLike, periodSlurp, periodGraph, repname, maxElements, timeZone, renameRules);
    }

    XYSeries getSeriesLinecount(String key) {
        key = this.formatLabel(key);
        for (int i2 = 0; i2 < this.collectionLinecount.getSeriesCount(); ++i2) {
            if (!this.collectionLinecount.getSeriesKey(i2).equals(key)) continue;
            return this.collectionLinecount.getSeries(i2);
        }
        XYSeries series = new XYSeries((Comparable)((Object)key), true, false);
        this.collectionLinecount.addSeries(series);
        return series;
    }

    TimePeriodValues getSeriesRevcount(String key) {
        for (int i2 = 0; i2 < this.collectionRevcount.getSeriesCount(); ++i2) {
            if (!this.collectionRevcount.getSeriesKey(i2).equals(key)) continue;
            return this.collectionRevcount.getSeries(i2);
        }
        TimePeriodValues series = new TimePeriodValues(key);
        this.collectionRevcount.addSeries(series);
        return series;
    }

    public XYSeriesCollection getLinecountCollection() {
        return this.collectionLinecount;
    }

    public TimePeriodValuesCollection getRevisioncountCollection() {
        return this.collectionRevcount;
    }

    private void addDatapoint(String key, int linecountTotal, int revcountTotal, Period period, String tooltipLabel) {
        this.getSeriesLinecount(key).add((double)period.getEndTime(), (double)linecountTotal);
        this.getSeriesRevcount(key).add(period.getTimePeriod(), (double)revcountTotal);
        this.addRevcountTooltip(period, revcountTotal, tooltipLabel);
    }

    public XYSeries getSeriesLinecount() {
        if (this.collectionLinecount.getSeriesCount() == 0) {
            return new XYSeries((Comparable)((Object)""), true, false);
        }
        return this.collectionLinecount.getSeries(0);
    }

    public CategoryTableXYDataset getRevcountForStack() {
        CategoryTableXYDataset data = new CategoryTableXYDataset();
        for (int i2 = 0; i2 < this.collectionRevcount.getSeriesCount(); ++i2) {
            TimePeriodValues series = this.collectionRevcount.getSeries(i2);
            for (int j = 0; j < series.getItemCount(); ++j) {
                data.add((double)((series.getTimePeriod(j).getStart().getTime() + series.getTimePeriod(j).getEnd().getTime()) / 2L), series.getValue(j).doubleValue(), series.getKey().toString());
            }
        }
        return data;
    }

    @Override
    public String[] getLegendItems() {
        if (this.collectionLinecount.getSeriesCount() == 0 || this.collectionLinecount.getSeries(0).getKey().equals("")) {
            return new String[0];
        }
        String[] items = new String[this.collectionLinecount.getSeriesCount()];
        for (int i2 = 0; i2 < this.collectionLinecount.getSeriesCount(); ++i2) {
            items[i2] = (String)((Object)this.collectionLinecount.getSeries(i2).getKey());
        }
        return items;
    }

    public Date getStartDate() {
        return this.dateStart;
    }

    public Date getEndDate() {
        return this.dateEnd;
    }

    @Override
    public boolean noGraphData() {
        return this.collectionLinecount.getSeriesCount() == 0 || this.collectionLinecount.getSeriesCount() == 1 && this.collectionLinecount.getSeries(0).getItemCount() == 0;
    }

    public boolean isShowLegend() {
        return this.showLegend;
    }

    private Pair<Integer, Integer> getFirstBuckets(int firstBucketDataSlurp, PeriodUnit periodSlurp, PeriodUnit periodGraph, boolean isTrunklike, TimeZone timeZone) throws InvalidBucketException {
        Period firstPeriodGraphDate = new Period(periodGraph, this.dateStart, timeZone);
        Period firstPeriodSlurpData = new Period(periodSlurp, firstBucketDataSlurp, timeZone);
        Period firstPeriodGraphData = new Period(periodGraph, firstPeriodSlurpData.getStartDate(), timeZone);
        if (isTrunklike) {
            firstPeriodGraphData.setToNextBucket(-1);
        }
        Period firstPeriodGraph = firstPeriodGraphDate.getStartTime() > firstPeriodGraphData.getStartTime() ? firstPeriodGraphDate : firstPeriodGraphData;
        return new Pair<Integer, Integer>(firstPeriodGraph.getBucket(), new Period(periodSlurp, firstPeriodGraph.getStartDate(), timeZone).getBucket());
    }

    private Pair<Integer, Integer> getLastBuckets(int lastBucketDataSlurp, PeriodUnit periodSlurp, PeriodUnit periodGraph, TimeZone timeZone) throws InvalidBucketException {
        Period lastPeriodGraphDate = new Period(periodGraph, this.dateEnd, timeZone);
        Period lastPeriodSlurpData = new Period(periodSlurp, lastBucketDataSlurp, timeZone);
        Period lastPeriodGraphData = new Period(periodGraph, lastPeriodSlurpData.getEndDate(), timeZone);
        Period lastPeriodGraph = lastPeriodGraphDate.getStartTime() < lastPeriodGraphData.getStartTime() ? lastPeriodGraphDate : lastPeriodGraphData;
        return new Pair<Integer, Integer>(lastPeriodGraph.getBucket(), new Period(periodSlurp, lastPeriodGraph.getEndDate(), timeZone).getBucket());
    }

    private void constructXYSeries(BucketDataCollection allBuckets, boolean isTrunkLike, PeriodUnit periodSlurp, PeriodUnit periodGraph, String repname, int MaxElements, TimeZone timeZone, RenamingRules renameRules) throws DbException {
        try {
            Pair<Integer, Integer> firstBuckets = this.getFirstBuckets(allBuckets.getFirstBucket(), periodSlurp, periodGraph, isTrunkLike, timeZone);
            int firstGraphBucket = firstBuckets.getFirst();
            int firstSlurpBucket = firstBuckets.getSecond();
            Pair<Integer, Integer> lastBuckets = this.getLastBuckets(allBuckets.getLastBucket(), periodSlurp, periodGraph, timeZone);
            int lastGraphBucket = lastBuckets.getFirst();
            int lastSlurpBucket = lastBuckets.getSecond();
            int numDataPoints = lastGraphBucket - firstGraphBucket + 1;
            Period[] dataPeriods = new Period[numDataPoints];
            for (int i2 = firstGraphBucket; i2 < lastGraphBucket + 1; ++i2) {
                dataPeriods[i2 - firstGraphBucket] = new Period(periodGraph, i2, timeZone);
            }
            for (Pair<String, BucketData> bucketData : allBuckets.consolidateAndSort(this.dateEnd, periodSlurp, periodGraph, timeZone, MaxElements, renameRules)) {
                String key = this.formatLabel(bucketData.getFirst());
                BucketData buckets = bucketData.getSecond();
                int totalLinecount = 0;
                int[] linecount = new int[numDataPoints];
                int[] revcount = new int[numDataPoints];
                int index = 0;
                for (Map.Entry<Integer, BucketDataElement> element : buckets) {
                    if (element.getKey() < firstSlurpBucket) {
                        totalLinecount += element.getValue().getLinecount();
                        continue;
                    }
                    if (element.getKey() > lastSlurpBucket) break;
                    Period slurpPeriod = new Period(periodSlurp, element.getKey(), timeZone);
                    while (index < dataPeriods.length && dataPeriods[index].getEndTime() < slurpPeriod.getEndTime()) {
                        ++index;
                    }
                    int n = index;
                    linecount[n] = linecount[n] + element.getValue().getLinecount();
                    int n2 = index;
                    revcount[n2] = revcount[n2] + element.getValue().getRevcount();
                }
                for (int i3 = 0; i3 < numDataPoints; ++i3) {
                    this.addDatapoint(key, totalLinecount += linecount[i3], revcount[i3], dataPeriods[i3], key);
                }
                if (numDataPoints != 1) continue;
                Period periodExtra = dataPeriods[0].getNextBucket(-1);
                this.addDatapoint(key, totalLinecount, 0, periodExtra, key);
            }
        }
        catch (InvalidBucketException e2) {
            Logs.APP_LOG.warn((Object)("Repository " + repname + ": Error parsing bucket: " + e2.getMessage()));
        }
    }

    static Pair<Date, Date> calculateDates(Date dateStart, Date dateEnd, int firstBucket, int lastBucket, PeriodUnit periodSlurp, TimeZone timeZone) throws InvalidBucketException {
        Period maxPeriod;
        Period periodParamStart;
        if (firstBucket > lastBucket) {
            lastBucket = firstBucket;
        }
        Period periodDataStart = new Period(periodSlurp, firstBucket, timeZone);
        Period periodDataEnd = new Period(periodSlurp, lastBucket, timeZone);
        if (dateStart == null) {
            dateStart = periodDataStart.getStartDate();
        }
        if (dateEnd == null) {
            dateEnd = periodDataEnd.getStartDate();
        }
        if (dateEnd.getTime() < dateStart.getTime()) {
            dateStart = periodDataStart.getStartDate();
            dateEnd = periodDataEnd.getEndDate();
        }
        Period minPeriod = (periodParamStart = new Period(periodSlurp, dateStart, timeZone)).getBucket() > periodDataStart.getBucket() ? periodParamStart : periodDataStart;
        Period periodParamEnd = new Period(periodSlurp, dateEnd, timeZone);
        Period period = maxPeriod = periodParamEnd.getBucket() < periodDataEnd.getBucket() ? periodParamEnd : periodDataEnd;
        if (minPeriod.getStartTime() > maxPeriod.getStartTime()) {
            minPeriod = periodDataStart;
            maxPeriod = periodDataEnd;
        }
        while (maxPeriod.getBucket() - minPeriod.getBucket() < 7) {
            maxPeriod.setToNextBucket(1);
            minPeriod.setToNextBucket(-1);
        }
        long buffer = (maxPeriod.getEndTime() - minPeriod.getEndTime()) / 18L;
        return new Pair<Date, Date>(new Date(minPeriod.getStartTime() - buffer), new Date(maxPeriod.getEndTime() + buffer));
    }

    static PeriodUnit choosePeriod(int graphWidth, Date minDate, Date maxDate, boolean isMiniChart) {
        long length = maxDate.getTime() - minDate.getTime();
        long maxBuckets = (graphWidth - 30) / (isMiniChart ? 3 : 5);
        double days = length / 86400000L;
        double weeks = days / 7.0;
        double months = days / 30.4;
        double years = days / 365.25;
        double quarters = years * 4.0;
        PeriodUnit result = PeriodUnit.YEAR;
        if (days < (double)maxBuckets) {
            result = PeriodUnit.DAY;
        } else if (weeks < (double)maxBuckets) {
            result = PeriodUnit.WEEK;
        } else if (months < (double)maxBuckets) {
            result = PeriodUnit.MONTH;
        } else if (quarters < (double)maxBuckets) {
            result = PeriodUnit.QUARTER;
        }
        return result;
    }

    class ParamSet {
        ParamSet(TimeZone timeZone, BucketDataCollection bucketsAll, boolean trunkLike, PeriodUnit periodSlurp, int width, Date date1, Date date2, String repname, boolean isMiniChart, boolean isBreakdownNone, int maxItemsInChart, RenamingRules renameRules) {
        }

        ParamSet(TimeZone timeZone, BucketDataCollection bucketsAll, boolean trunkLike, PeriodUnit periodSlurp, int width, Date date1, Date date2, String repname, boolean isMiniChart, boolean isBreakdownNone, RenamingRules renameRules) {
        }

        ParamSet(TimeZone timeZone, BucketDataCollection bucketsAll, boolean trunkLike, PeriodUnit periodSlurp, PeriodUnit periodGraph, String repname) {
        }
    }
}

