/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.bucket;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.bucket.ParameterSet;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ParameterSetInsert
extends ParameterSet {
    public final Map<String, Integer> linecountByAuthor;
    public final int numRevisions;
    public final int bucket;
    public final boolean isTrunklike;
    private static final String[] NO_AUTHOR_SYNONYMS = new String[]{"", "no_author"};
    public final String extension;

    public ParameterSetInsert(Path path, String branch, int bucket, Map<String, Integer> linecountByAuthor, int numRevisions, boolean isTrunklike, boolean caseSensitive) {
        super(path, branch, caseSensitive);
        this.extension = ParameterSetInsert.getExtension(path);
        this.linecountByAuthor = linecountByAuthor;
        this.numRevisions = numRevisions;
        this.bucket = bucket;
        this.isTrunklike = isTrunklike;
        this.checkAuthors();
    }

    public ParameterSetInsert(Path path, String branch, int bucket, int linecount, int numRevisions, String commitAuthor, boolean isTrunklike, boolean caseSensitive) {
        super(path, branch, caseSensitive);
        this.linecountByAuthor = new HashMap<String, Integer>();
        this.linecountByAuthor.put(commitAuthor, linecount);
        this.numRevisions = numRevisions;
        this.bucket = bucket;
        this.isTrunklike = isTrunklike;
        this.extension = ParameterSetInsert.getExtension(path);
        this.checkAuthors();
    }

    private static String getExtension(Path path) {
        String file;
        String extn = "__NO_EXTENSION__";
        if (path.numComponents() > 0 && (file = path.getComponent(path.numComponents() - 1)).contains(".")) {
            extn = file.substring(file.lastIndexOf("."));
        }
        return extn;
    }

    private void checkAuthors() {
        int total = 0;
        for (String syn : NO_AUTHOR_SYNONYMS) {
            if (!this.linecountByAuthor.containsKey(syn)) continue;
            total += this.linecountByAuthor.get(syn).intValue();
            this.linecountByAuthor.remove(syn);
        }
        if (total > 0) {
            this.linecountByAuthor.put("__NO_AUTHOR__", total);
        }
    }

    @Override
    public String toString() {
        return "Parameters: path " + this.path + ", branch " + this.branch + ", extension " + this.extension + ", linecountByAuthor " + this.linecountByAuthor + ", numRevisions " + this.numRevisions + ", bucket " + this.bucket;
    }
}

