/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cache;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cache.RecentChangesParams;
import com.cenqua.fisheye.diff.Hunk;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.infinitydb.query3.AndQuery3;
import com.cenqua.fisheye.infinitydb.query3.Query3;
import com.cenqua.fisheye.rep.Blame;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.DirInfo;
import com.cenqua.fisheye.rep.FileHistory;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.rep.impl.CommonQuery3Helper;
import com.cenqua.obfuscate.idbk4ui8v._EntityClass;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.EventListener;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface RevisionCache {
    public static final String CVS_REPTYPE = "cvs";
    public static final String SVN_REPTYPE = "svn";
    public static final String P4_REPTYPE = "p4";
    public static final String[] KNOWN_REPTYPES = new String[]{"cvs", "svn", "p4"};
    public static final String CUSTOM_REPTYPE = "custom";

    public void addListener(CacheListener var1);

    public Path[] listFiles(Path var1) throws DbException;

    public Path[] listDirs(Path var1) throws DbException;

    public boolean isFile(Path var1) throws DbException;

    public boolean isDir(Path var1) throws DbException;

    public void getTextRevision(RevInfoKey var1, OutputStream var2, String var3, String var4) throws IOException, DbException;

    public void getBinaryRevision(RevInfoKey var1, OutputStream var2) throws IOException, DbException;

    public Charset getTextEncoding(RevInfoKey var1) throws DbException;

    public FileRevision getFileRevision(int var1) throws DbException;

    public FileRevision getFileRevision(RevInfoKey var1) throws DbException;

    public ChangeSet getChangeSet(String var1) throws DbException;

    public String getChangeSetId(RevInfoKey var1) throws DbException;

    public List findRecentChangeSetIds(RecentChangesParams var1) throws DbException;

    public List findRecentChangeSets(RecentChangesParams var1) throws DbException;

    public FileRevision getLatestFileRevision(Path var1) throws DbException;

    public FileHistory getFullFileHistory(Path var1, boolean var2) throws DbException;

    public FileHistory getFileHistory(Path var1, boolean var2) throws DbException;

    public FileHistory getFullFileHistory(Path var1) throws DbException;

    public FileHistory getFileHistory(Path var1) throws DbException;

    public Blame getBlame(RevInfoKey var1) throws DbException, IOException;

    public String getRepositoryType();

    public long getLastModifiedDate() throws DbException;

    public long getCacheSerialNumber();

    public DirInfo findDirInfo(Path var1) throws DbException;

    public void visitMatchingStringTerms(Path var1, boolean var2, _EntityClass var3, CommonQuery3Helper.StringVisitor var4) throws DbException;

    public int countRevisions(Path var1, long var2, long var4, Query3 var6) throws DbException;

    public List<String> getSimilarChangeSetIds(String var1) throws DbException;

    public List<String> findSimilarPartialChangeSetIds(String var1) throws DbException;

    public List<String> findBranches(Path var1) throws DbException;

    public List<String> findAuthors(Path var1) throws DbException;

    public String getImpliedBranch(Path var1);

    public AndQuery3 findRevisionsUnderDirQuery3(Path var1, boolean var2);

    public InfinityDbHandle getInfDb();

    public int findLastSuccessor(int var1) throws DbException;

    public boolean isBefore(int var1, int var2) throws DbException;

    public boolean isAfter(int var1, int var2) throws DbException;

    public boolean isCaseSensitive();

    public boolean showAuthorLinecount();

    public List<Hunk> getHunks(RevInfoKey var1) throws DbException;

    public static interface KeyVisitor {
        public void visit(int var1) throws IOException;
    }

    public static interface CacheListener
    extends EventListener {
        public void cacheUpdated();
    }
}

