/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.ctl;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.ctl.BaseCommand;
import com.cenqua.fisheye.web.util.InetAddrPort;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.xmlbeans.XmlOptions;

public abstract class BaseRemoteCommand
extends BaseCommand {
    protected List<String> args = new ArrayList<String>();

    public int mainImpl(String[] argArray) {
        BaseRemoteCommand.setupLogging(true);
        LinkedList<String> argList = new LinkedList<String>(Arrays.asList(argArray));
        if (!BaseRemoteCommand.handleCommonArguments(argList, System.err)) {
            return 1;
        }
        this.args = argList;
        if (!this.processArgs()) {
            if (this.args.isEmpty()) {
                System.err.println("Bad arguments");
            } else {
                System.err.println("Bad argument: " + this.args.get(0));
            }
            return 1;
        }
        String key = "cenqua";
        String ctlBind = null;
        try {
            if (AppConfig.getConfigurationFile().isFile()) {
                ConfigDocument doc = RootConfig.parseDocument(AppConfig.getConfigurationFile(), new XmlOptions());
                ctlBind = doc.getConfig().getControlBind();
            } else {
                System.err.println("Warning: could not find " + AppConfig.getConfigurationFile());
            }
            if (ctlBind == null) {
                ctlBind = "127.0.0.1:8078";
            }
            int status = this.sendCommand(new InetAddrPort(ctlBind), key);
            return status;
        }
        catch (ConnectException e2) {
            System.err.println("FishEye not running? Problem connecting to " + ctlBind + " : " + e2.getMessage());
        }
        catch (IOException e3) {
            System.err.println("Problem connecting to " + ctlBind + " : " + e3.getMessage());
        }
        catch (Exception e4) {
            System.err.println("Problem connecting to " + ctlBind);
            e4.printStackTrace();
        }
        return 1;
    }

    protected boolean processArgs() {
        return this.args.isEmpty();
    }

    public int sendCommand(InetAddrPort port, String key) throws Exception {
        InetAddress addr = port.getInetAddress();
        if (addr == null) {
            addr = InetAddress.getLocalHost();
        }
        Socket s = new Socket(addr, port.getPort());
        s.setTcpNoDelay(true);
        OutputStream out = s.getOutputStream();
        out.write((key + "\r\n").getBytes());
        this.sendCommand(out);
        out.write("\r\n".getBytes());
        out.flush();
        int status = 0;
        BufferedReader in = new BufferedReader(new InputStreamReader(s.getInputStream()));
        String line = in.readLine();
        while (line != null) {
            if (line.startsWith(key)) {
                status = Integer.parseInt(in.readLine());
            } else {
                System.err.println(line);
            }
            line = in.readLine();
        }
        s.close();
        return status;
    }

    protected abstract void sendCommand(OutputStream var1) throws IOException;
}

