/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep;

import antlr.TokenStreamException;
import antlr.TokenStreamIOException;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cvsrep.AbstractRCSParseListener;
import com.cenqua.fisheye.cvsrep.ChangeTree;
import com.cenqua.fisheye.cvsrep.RCSParseListener;
import com.cenqua.fisheye.cvsrep.RCSParser;
import com.cenqua.fisheye.cvsrep.RcsFileHistory;
import com.cenqua.fisheye.cvsrep.RcsRevisionInfo;
import com.cenqua.fisheye.cvsrep.RcsStringToken;
import com.cenqua.fisheye.cvsrep.RcsUtil;
import com.cenqua.fisheye.cvsrep.Revision;
import com.cenqua.fisheye.io.BufferedRandomAccessInputStream;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.logging.Logs;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RcsFileHistoryFactory
extends AbstractRCSParseListener {
    private final ChangeTree mTree;
    private final RcsFileHistory mHistory = new RcsFileHistory();
    private final Map<Revision, RcsRevisionInfo> mRevisionMap = new HashMap<Revision, RcsRevisionInfo>();
    private final Map<String, Revision> mSymbolMap = new HashMap<String, Revision>();
    private final Map<Revision, Revision> mNextMap = new HashMap<Revision, Revision>();
    private final Map<Revision, Revision> mNext2Map = new HashMap<Revision, Revision>();
    private final Map<Revision, Revision> mBranchPoints = new HashMap<Revision, Revision>();
    private final Map<String, Revision> mRevisionInternPool = new HashMap<String, Revision>();
    private final Path mPath;
    private final Charset mCharset;
    private final BufferedRandomAccessInputStream mFile;
    private RcsRevisionInfo mCurrentInfo;
    private Revision mHead;

    private RcsFileHistoryFactory(Path aPath, BufferedRandomAccessInputStream aFileStream, Charset cs) {
        this.mPath = aPath;
        this.mFile = aFileStream;
        this.mCharset = cs;
        this.mHistory.setPath(this.mPath);
        this.mTree = new ChangeTree();
    }

    @Override
    public void adminHead(String num) {
        this.mHead = this.newRevision(num);
        this.mHistory.setHead(num);
    }

    @Override
    public void adminSymbol(String symbol, String number) {
        this.mSymbolMap.put(symbol, this.newRevision(number));
    }

    @Override
    public void adminExpand(RcsStringToken t) throws TokenStreamException {
        String str = RcsUtil.rcsStringToString(t, this.mCharset, this.mFile).toString();
        this.mHistory.setExpand(str);
    }

    @Override
    public void startDelta(String num, String date, String author) {
        Revision rev = this.newRevision(num);
        this.mCurrentInfo = new RcsRevisionInfo(this.mHistory, rev);
        this.mRevisionMap.put(rev, this.mCurrentInfo);
        this.mCurrentInfo.setDate(RcsUtil.parseDate(date));
        this.mCurrentInfo.setAuthor(author);
        this.mHistory.add(this.mCurrentInfo);
        this.mTree.addRevision(rev);
    }

    @Override
    public void deltaState(String id) {
        this.mCurrentInfo.setState(id);
    }

    @Override
    public void deltaNext(String num) {
        Revision rev = this.newRevision(num);
        Revision cur = this.mCurrentInfo.getCvsRevision();
        this.mNextMap.put(rev, cur);
        this.mNext2Map.put(cur, rev);
    }

    @Override
    public void deltaBranch(String num) {
        Revision br = this.newRevision(num);
        this.mBranchPoints.put(br, this.mCurrentInfo.getCvsRevision());
    }

    @Override
    public void endDeltaSection() {
        RcsRevisionInfo info;
        Revision bp;
        for (String sym : this.mSymbolMap.keySet()) {
            Revision rev = this.mSymbolMap.get(sym);
            if (rev.isBranchNumber()) {
                bp = rev.getBranchPointRevision2();
                RcsRevisionInfo info2 = this.mRevisionMap.get(bp);
                if (info2 != null) {
                    this.mHistory.setBranchPoint(sym, bp);
                    String bpTag = sym + "$BP";
                    info2.addSymbol(bpTag);
                    this.mHistory.addSymbol(bpTag, bp);
                    continue;
                }
                Logs.APP_LOG.warn((Object)("could not map symbol to branchpoint (skipping):  rev=" + rev + " sym=" + sym + " bp=" + bp + " file=" + this.mFile.getFile()));
                continue;
            }
            info = this.mRevisionMap.get(rev);
            if (info != null) {
                info.addSymbol(sym);
                this.mHistory.addSymbol(sym, rev);
                continue;
            }
            Logs.APP_LOG.warn((Object)("no such revision for symbol (tag), skipping:  rev=" + rev + " sym=" + sym + " file=" + this.mFile.getFile()));
        }
        for (Revision br : this.mBranchPoints.keySet()) {
            Revision point = this.mBranchPoints.get(br);
            info = this.mRevisionMap.get(br);
            info.setAncestor(this.mRevisionMap.get(point), 1);
            this.setupAncestor(br, point);
        }
        HashMap<String, List<Revision>> branches = new HashMap<String, List<Revision>>();
        for (Revision brFirst : this.mBranchPoints.keySet()) {
            bp = this.mBranchPoints.get(brFirst);
            Revision brRev = brFirst.trimLast();
            Revision brMagicRev = brFirst.getMagicBranch();
            String brName = null;
            for (String sym : this.mSymbolMap.keySet()) {
                boolean hit;
                Revision symrev = this.mSymbolMap.get(sym);
                if (!symrev.isBranchNumber() || !(hit = symrev.isNormalBranchNumber() && symrev.equals(brRev) || symrev.isMagicBranchNumber() && symrev.equals(brMagicRev))) continue;
                brName = sym;
                break;
            }
            if (brName == null) {
                String brStr = brRev.toString();
                brName = this.makeBranchName(brStr, brStr + "_BRANCH", branches.keySet());
            }
            this.mHistory.setBranchPoint(brName, bp);
            branches.put(brName, this.collectBranch(brFirst));
        }
        String mainBrName = this.makeBranchName("MAIN", "1", branches.keySet());
        branches.put(mainBrName, this.collectBranch(this.mHead));
        this.mHistory.setMainBranchName(mainBrName);
        for (Map.Entry entry : branches.entrySet()) {
            String brName = (String)entry.getKey();
            List revs = (List)entry.getValue();
            RcsRevisionInfo last = null;
            for (Revision rev : revs) {
                RcsRevisionInfo info3 = this.mRevisionMap.get(rev);
                info3.setThisBranch(brName);
                if (last != null) {
                    info3.setAncestor(last, 0);
                    last.setNextInBranch(info3);
                    this.setupAncestor(rev, last.getCvsRevision());
                }
                last = info3;
            }
        }
        this.mHistory.setBranches(branches);
    }

    private List<Revision> collectBranch(Revision cur) {
        ArrayList<Revision> revs = new ArrayList<Revision>();
        while (cur != null) {
            revs.add(cur);
            cur = this.mNext2Map.get(cur);
        }
        Collections.sort(revs);
        return revs;
    }

    private String makeBranchName(String prefered1, String prefered2, Set existingBranchNames) {
        if (!existingBranchNames.contains(prefered1) && !this.mSymbolMap.containsKey(prefered1)) {
            return prefered1;
        }
        if (!existingBranchNames.contains(prefered2) && !this.mSymbolMap.containsKey(prefered2)) {
            return prefered2;
        }
        String s = prefered1;
        while (existingBranchNames.contains(s) || this.mSymbolMap.containsKey(s)) {
            s = "_" + s;
        }
        return s;
    }

    private void setupAncestor(Revision aDescendant, Revision aAncestor) {
        this.mTree.setupAncestor(aDescendant, aAncestor);
        if (!this.mNextMap.containsKey(aDescendant)) {
            this.mNextMap.put(aDescendant, aAncestor);
        }
    }

    @Override
    public void startDeltatext(String num) {
        Revision rev = this.newRevision(num);
        this.mCurrentInfo = this.mRevisionMap.get(rev);
    }

    @Override
    public void deltatextLog(RcsStringToken text) throws TokenStreamException {
        this.mCurrentInfo.setComment(RcsUtil.rcsStringToString(text, this.mCharset, this.mFile).toString());
    }

    @Override
    public void deltatextText(RcsStringToken text) throws TokenStreamIOException {
        InputStream in;
        block6: {
            in = null;
            try {
                Revision revision;
                if (!this.mHistory.isBinary()) {
                    in = text.getInputStream(this.mFile);
                }
                if ((revision = this.mCurrentInfo.getCvsRevision()).equals(this.mHead)) {
                    this.mTree.setHeadText(revision, in);
                    break block6;
                }
                this.mTree.setDeltaText(this.mNextMap.get(revision), revision, in);
            }
            catch (IOException e2) {
                try {
                    Logs.APP_LOG.error((Object)("parsing deltatext string in " + this.mFile.getFile() + " at " + text.getStart() + "-" + text.getEnd()), (Throwable)e2);
                    throw new TokenStreamIOException(e2);
                }
                catch (Throwable throwable) {
                    IOHelper.close(in);
                    throw throwable;
                }
            }
        }
        IOHelper.close(in);
    }

    private void fixup() {
        for (RcsRevisionInfo info : this.mRevisionMap.values()) {
            info.fixup();
        }
        this.mHistory.setHeadByteCount(this.mTree.getHeadBytes());
    }

    private Revision newRevision(String num) {
        int max = 1000;
        Revision r = this.mRevisionInternPool.get(num);
        if (r == null) {
            r = new Revision(num);
            if (this.mRevisionInternPool.size() <= max) {
                this.mRevisionInternPool.put(num, r);
            }
        }
        return r;
    }

    public static Result createHistory(final BufferedRandomAccessInputStream in, final Charset cs, final Path aPath) throws IOException, RCSParser.ParseException {
        try {
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class MyLF
            implements RCSParser.ListenerFactory {
                RcsFileHistoryFactory factory;

                MyLF() {
                }

                @Override
                public RCSParseListener getListener() {
                    this.factory = new RcsFileHistoryFactory(aPath, in, cs);
                    return this.factory;
                }
            }
            MyLF lf = new MyLF();
            RCSParser.parse(in, cs, lf);
            RcsFileHistoryFactory factory = lf.factory;
            factory.fixup();
            factory.mTree.postProcess(factory.mRevisionMap);
            return new Result(factory.mTree, factory.mHistory);
        }
        catch (RuntimeException e2) {
            Logs.APP_LOG.warn((Object)("problem parsing " + in.getFile()), (Throwable)e2);
            throw new RCSParser.ParseException("problem parsing " + in.getFile(), e2);
        }
        catch (Error e3) {
            Logs.APP_LOG.error((Object)("internal error while parsing " + in.getFile()), (Throwable)e3);
            throw new RCSParser.ParseException("internal error parsing " + in.getFile(), e3);
        }
    }

    public static class Result {
        private final ChangeTree mTree;
        private final RcsFileHistory mHistory;

        public Result(ChangeTree aTree, RcsFileHistory aHistory) {
            this.mTree = aTree;
            this.mHistory = aHistory;
        }

        public ChangeTree getTree() {
            return this.mTree;
        }

        public RcsFileHistory getHistory() {
            return this.mHistory;
        }
    }
}

