/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep.cache;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cvsrep.CvsRepository;
import com.cenqua.fisheye.cvsrep.CvsRepositoryEngine;
import com.cenqua.fisheye.cvsrep.RCSParser;
import com.cenqua.fisheye.cvsrep.RcsFileHistory;
import com.cenqua.fisheye.cvsrep.cache.CvsDirInfo;
import com.cenqua.fisheye.cvsrep.cache.MutableRevisionInfoCache;
import com.cenqua.fisheye.cvsrep.cache.RepositoryIndex;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryStatus;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

class CachedDirUpdater {
    private final Path mDir;
    private final CvsRepository mRep;
    private final MutableRevisionInfoCache mDB;
    private final RepositoryIndex mIndex;
    private final CvsDirInfo mInfo;
    private final boolean mIsNewInfo;
    private final RepositoryStatus status;

    public CachedDirUpdater(Path dir, CvsRepositoryEngine rcfg, MutableRevisionInfoCache db, RepositoryStatus status) throws DbException {
        this.mDir = dir;
        this.mRep = rcfg.getRepository();
        this.mDB = db;
        this.status = status;
        this.mIndex = rcfg.makeCachedCvsRepository().getIndex();
        CvsDirInfo info = this.mDB.findCvsDirInfo(this.mDir);
        boolean isNewInfo = false;
        if (info == null) {
            info = new CvsDirInfo(this.mDir);
            isNewInfo = true;
        }
        this.mInfo = info;
        this.mIsNewInfo = isNewInfo;
    }

    boolean scanPhase1() throws DbException {
        boolean wasUpdated = this.recomputeDirInfo(this.mIsNewInfo);
        if (wasUpdated) {
            this.flush();
        }
        return wasUpdated || this.mIsNewInfo;
    }

    private boolean recomputeDirInfo(boolean isNewInfo) throws DbException {
        boolean changed;
        Path[] realFiles = this.mRep.listFiles(this.mDir);
        long[] timestamps = new long[realFiles.length];
        long youngest = 0L;
        for (int i2 = 0; i2 < realFiles.length; ++i2) {
            Path realPath = realFiles[i2];
            try {
                File realFile = this.mRep.getFilesystemFileForPath(realPath);
                long ts = realFile.lastModified();
                if (ts > youngest) {
                    youngest = ts;
                }
                timestamps[i2] = ts;
                continue;
            }
            catch (FileNotFoundException e2) {
                // empty catch block
            }
        }
        long previousYoungest = this.mInfo.getYoungestTimestamp();
        boolean bl = changed = this.mInfo.getFileCount() != realFiles.length || previousYoungest != youngest;
        if (changed || isNewInfo) {
            Logs.PERF_LOG.debug((Object)("updating " + this.mDir));
            this.mInfo.setFileCount(realFiles.length);
            this.mInfo.setYoungestTimestamp(youngest);
            BatchingIndexer indexer = new BatchingIndexer();
            for (int i3 = 0; i3 < realFiles.length; ++i3) {
                if (this.status.isStopRequested()) {
                    Logs.APP_LOG.info((Object)"stop requested");
                    return false;
                }
                Path realPath = realFiles[i3];
                long ts = timestamps[i3];
                if (ts <= previousYoungest) continue;
                if (Logs.PERF_LOG.isDebugEnabled()) {
                    long tot = Runtime.getRuntime().totalMemory();
                    long free = Runtime.getRuntime().freeMemory();
                    Logs.PERF_LOG.debug((Object)(" changed, parsing " + realPath + " (free=" + (tot == 0L ? -1L : free * 100L / tot) + "%, " + free + "/" + tot + ")"));
                }
                try {
                    RcsFileHistory history = this.mRep.getFileHistoryInfo(realPath);
                    if (history.getRevisions().isEmpty()) {
                        Logs.APP_LOG.info((Object)("NOTE: skipping file with no revisions: " + realPath));
                        continue;
                    }
                    indexer.addToIndex(history);
                    continue;
                }
                catch (IOException e3) {
                    Logs.APP_LOG.error((Object)("could not parse " + realPath + " , skipping"), (Throwable)e3);
                    continue;
                }
                catch (RCSParser.ParseException e4) {
                    Logs.APP_LOG.error((Object)("could not parse " + realPath + " , skipping"), (Throwable)e4);
                }
            }
            indexer.batchFlush();
            this.mDB.putDirInfo(this.mInfo);
            this.flush();
        }
        return changed;
    }

    private void flush() throws DbException {
        this.mIndex.flush();
        this.mDB.commit();
    }

    private class BatchingIndexer {
        public static final int BATCH_SIZE = 200;
        private final List<RcsFileHistory> mToIndex = new ArrayList<RcsFileHistory>(200);
        private int mSize = 0;

        private BatchingIndexer() {
        }

        public void addToIndex(RcsFileHistory hist) throws DbException {
            this.mToIndex.add(hist);
            this.mSize += hist.getRevisions().size();
            if (this.mSize >= 200) {
                this.batchFlush();
            } else {
                long tot = Runtime.getRuntime().totalMemory();
                long free = Runtime.getRuntime().freeMemory();
                int thresh = 10;
                if (free == 0L || tot / free >= 10L) {
                    Logs.PERF_LOG.debug((Object)"batching now, to free more memory");
                    this.batchFlush();
                }
            }
        }

        public void batchFlush() throws DbException {
            if (!this.mToIndex.isEmpty()) {
                Logs.PERF_LOG.debug((Object)("batching " + this.mToIndex.size() + " files (" + this.mSize + " revs)"));
                CachedDirUpdater.this.mDB.index(this.mToIndex);
                CachedDirUpdater.this.mIndex.indexFiles(this.mToIndex);
                this.mToIndex.clear();
                this.mSize = 0;
            }
            CachedDirUpdater.this.flush();
        }
    }
}

