/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep.cache;

import com.cenqua.fisheye.cvsrep.cache.CvsCSID;
import com.cenqua.fisheye.cvsrep.cache.CvsRevInfo;
import com.cenqua.fisheye.cvsrep.cache.RevisionInfoCache;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RevInfoKey;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyChangeSet
extends ChangeSet {
    private final TIntArrayList revids;
    private final RevisionInfoCache mDB;
    private final CvsCSID mId;
    private long date = 0L;
    private String comment = null;
    private String author = null;

    public LazyChangeSet(CvsCSID newId, TIntArrayList revids, RevisionInfoCache db) throws DbException {
        this.revids = revids;
        this.mId = newId;
        this.mDB = db;
        if (revids.size() > 0) {
            int revid = revids.get(0);
            CvsRevInfo first = this.mDB.findRevInfo(revid);
            this.init(first);
        }
    }

    public CvsCSID getCvsId() {
        return this.mId;
    }

    @Override
    public int getRevisionInfosCount() {
        return this.revids.size();
    }

    @Override
    public Iterator<RevInfoKey> getRevisionInfoKeys() throws DbException {
        ArrayList<RevInfoKey> keys = new ArrayList<RevInfoKey>();
        for (int i2 = 0; i2 < this.revids.size(); ++i2) {
            int revid = this.revids.get(i2);
            keys.add(this.mDB.getCommonRevInfoDAO().getKey(revid));
        }
        return keys.iterator();
    }

    @Override
    public FileRevision getRevisionInfo(int i2) throws DbException {
        int revid = this.revids.get(i2);
        return this.mDB.findRevInfo(revid);
    }

    protected void init(FileRevision info) {
        this.date = info.getDate();
        this.comment = info.getComment();
        this.author = info.getAuthor();
    }

    @Override
    public Set getReviewIds() throws DbException {
        return this.mDB.getCommonRevInfoDAO().getReviewsForRevids(this.revids);
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public long getDate() {
        return this.date;
    }

    @Override
    public String getAuthor() {
        return this.author;
    }

    @Override
    public String getBranch() {
        return this.mId == null ? "" : this.mId.getBranch();
    }

    @Override
    public String getId() {
        return this.mId == null ? "" : this.mId.toString();
    }

    public String toString() {
        return this.mId == null ? "-" : this.mId.toString();
    }
}

