/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep.quicksearch;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.logging.Logs;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;

public class QuickSearchParams {
    final List<String> commentTerms = new LinkedList<String>();
    final List<String> filenameTerms = new LinkedList<String>();
    final List<String> authorTerms = new LinkedList<String>();
    final List<String> tagTerms = new LinkedList<String>();
    final List<String> branchTerms = new LinkedList<String>();
    final List<String> csidTerms = new LinkedList<String>();
    private boolean searchAllDirs = false;
    final Path path;
    private final Analyzer commentAnalyzer;

    public QuickSearchParams(Analyzer analyzer, Path path) {
        this.commentAnalyzer = analyzer;
        this.path = path;
    }

    public boolean isSearchAllDirs() {
        return this.searchAllDirs;
    }

    public void setSearchAllDirs(boolean searchAllDirs) {
        this.searchAllDirs = searchAllDirs;
    }

    public Path getPath() {
        return this.searchAllDirs ? new Path() : this.path;
    }

    public void addAny(String term) {
        this.addCommentTerm(term);
        this.addFilenameTerm(term);
        this.addAuthorTerm(term);
        this.addTagTerm(term);
        this.addBranchTerm(term);
        this.addCsidTerm(term);
    }

    public void addCommentTerm(String term) {
        try {
            Token t;
            TokenStream ts = this.commentAnalyzer.tokenStream("comment", (Reader)new StringReader(term));
            while (null != (t = ts.next())) {
                this.commentTerms.add(t.termText());
            }
            ts.close();
        }
        catch (IOException e2) {
            Logs.APP_LOG.info((Object)"unexpected IO from a string reader", (Throwable)e2);
        }
    }

    public void addFilenameTerm(String term) {
        this.filenameTerms.add(term);
    }

    public void addAuthorTerm(String term) {
        if (term != null) {
            term = term.toLowerCase(Locale.US);
        }
        this.authorTerms.add(term);
    }

    public void addTagTerm(String term) {
        this.tagTerms.add(term);
    }

    public void addBranchTerm(String term) {
        this.branchTerms.add(term);
    }

    public void addCsidTerm(String term) {
        this.csidTerms.add(term);
    }
}

