/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep.quicksearch;

import com.cenqua.fisheye.web.UrlHelper;
import java.util.LinkedList;
import java.util.List;

public class QuickSearchResults {
    private TermResults mCommentResults = null;
    private TermResults mFileResults = null;
    private TermResults mAuthorResults = null;
    private TermResults mBranchResults = null;
    private TermResults mTagResults = null;
    private TermResults csidResults = null;

    public UrlHelper getExactMatchRedirect() {
        TermResults[] allResults = this.getAllResults();
        UrlHelper url = null;
        int count = 0;
        for (TermResults result : allResults) {
            if (result == null) continue;
            count += result.getResultCount();
            UrlHelper u = result.getExactMatchRedirect();
            if (u == null) continue;
            url = u;
        }
        return count == 1 ? url : null;
    }

    public int getTotalResultCount() {
        TermResults[] allResults = this.getAllResults();
        int count = 0;
        for (TermResults result : allResults) {
            if (result == null) continue;
            count += result.getResultCount();
        }
        return count;
    }

    private TermResults[] getAllResults() {
        TermResults[] allResults = new TermResults[]{this.mCommentResults, this.mFileResults, this.mAuthorResults, this.mBranchResults, this.mTagResults, this.csidResults};
        return allResults;
    }

    public TermResults getCommentResults() {
        return this.mCommentResults;
    }

    public TermResults getFileResults() {
        return this.mFileResults;
    }

    public void setCommentResults(TermResults results) {
        this.mCommentResults = results;
    }

    public void setFileResults(TermResults results) {
        this.mFileResults = results;
    }

    public TermResults getAuthorResults() {
        return this.mAuthorResults;
    }

    public void setAuthorResults(TermResults authorResults) {
        this.mAuthorResults = authorResults;
    }

    public TermResults getBranchResults() {
        return this.mBranchResults;
    }

    public void setBranchResults(TermResults branchResults) {
        this.mBranchResults = branchResults;
    }

    public TermResults getTagResults() {
        return this.mTagResults;
    }

    public void setTagResults(TermResults tagResults) {
        this.mTagResults = tagResults;
    }

    public TermResults getCsidResults() {
        return this.csidResults;
    }

    public void setCsidResults(TermResults csidResults) {
        this.csidResults = csidResults;
    }

    public static class TermResults {
        private final List<ItemMatch> mItems = new LinkedList<ItemMatch>();
        private int mResultCount = 0;
        private int mUnionResultCount = 0;
        private String mUnionQueryString = null;
        private UrlHelper mExactMatchRedirect = null;

        public int getResultCount() {
            return this.mResultCount;
        }

        public int getUnionResultCount() {
            return this.mUnionResultCount;
        }

        public UrlHelper getExactMatchRedirect() {
            return this.mExactMatchRedirect;
        }

        public void setExactMatchRedirect(UrlHelper exactMatchRedirect) {
            this.mExactMatchRedirect = exactMatchRedirect;
        }

        void setUnionResultCount(int unionResultCount) {
            this.mUnionResultCount = unionResultCount;
        }

        public List getItems() {
            return this.mItems;
        }

        void addMatch(Object match, int count) {
            this.mItems.add(new ItemMatch(match, count));
            this.mResultCount += count;
        }

        void addMatch(Object match, int count, List subresults, boolean truncated) {
            this.addMatch(new ItemMatch(match, count, subresults, truncated));
        }

        void addMatch(ItemMatch itemMatch) {
            this.mItems.add(itemMatch);
            this.mResultCount += itemMatch.getCount();
        }

        public Object getExactMatch() {
            if (this.mResultCount != 1) {
                return null;
            }
            Object match = null;
            for (ItemMatch item : this.mItems) {
                List subResults = item.getSubResults();
                if (subResults.size() != 1) continue;
                match = subResults.get(0);
            }
            return match;
        }

        public String getUnionQueryString() {
            return this.mUnionQueryString;
        }

        public void setUnionQueryString(String s) {
            this.mUnionQueryString = s;
        }
    }

    public static class ItemMatch {
        private final Object mItem;
        private final int mCount;
        private List mSubResults;
        private boolean mSubResultsTruncated = false;

        public ItemMatch(Object item, int count) {
            this(item, count, null, false);
        }

        public ItemMatch(Object item, int count, List subResults, boolean subResultsTruncated) {
            this.mItem = item;
            this.mCount = count;
            this.mSubResults = subResults;
            this.mSubResultsTruncated = subResultsTruncated;
        }

        public Object getItem() {
            return this.mItem;
        }

        public int getCount() {
            return this.mCount;
        }

        public List getSubResults() {
            return this.mSubResults;
        }

        public void setSubResults(List subResults) {
            this.mSubResults = subResults;
        }

        public boolean isSubResultsTruncated() {
            return this.mSubResultsTruncated;
        }

        public void setSubResultsTruncated(boolean subResultsTruncated) {
            this.mSubResultsTruncated = subResultsTruncated;
        }
    }
}

