/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep.quicksearch;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.cvsrep.quicksearch.QuickSearchResults;
import com.cenqua.fisheye.cvsrep.quicksearch.QuickSearcher;
import com.cenqua.fisheye.infinitydb.UniqueStringTable;
import com.cenqua.fisheye.infinitydb.query3.AndQuery3;
import com.cenqua.fisheye.infinitydb.query3.TermLookupQuery3;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.impl.CommonQuery3Helper;
import com.cenqua.obfuscate.idbk4ui8v._EntityClass;
import com.cenqua.obfuscate.idbk4ui8v._ItemSpace;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TermLookupQuickSearch
implements QuickSearcher.SearchAlgorithm {
    private final _EntityClass entity;
    private final _EntityClass tableclass;
    private final RepositoryEngine eng;
    private final _ItemSpace db;

    public TermLookupQuickSearch(QuickSearcher searcher, _EntityClass tableclass, _EntityClass entity) throws DbException {
        this.entity = entity;
        this.tableclass = tableclass;
        this.eng = searcher.getEngine();
        this.db = this.eng.getRevisionCache().getInfDb().get();
    }

    @Override
    public QuickSearchResults.TermResults search(Path path, List<String> origParams) throws IOException, DbException {
        if (origParams.isEmpty()) {
            return null;
        }
        List<String> params = this.matchingTerms(origParams);
        if (params.isEmpty()) {
            return null;
        }
        LuceneConnection conn = null;
        RevisionCache cache = this.eng.getRevisionCache();
        QuickSearchResults.TermResults matches = new QuickSearchResults.TermResults();
        AndQuery3 unionQuery = CommonQuery3Helper.findRevisionsUnderDirQuery3(path, cache.isCaseSensitive());
        for (String term : params) {
            AndQuery3 bq = CommonQuery3Helper.findRevisionsUnderDirQuery3(path, cache.isCaseSensitive());
            TermLookupQuery3 query = new TermLookupQuery3(this.tableclass, this.entity, term, null);
            bq.addClause(query);
            int count = bq.countMatches(this.db, conn);
            matches.addMatch(term, count);
            if (count <= 0) continue;
            unionQuery.addClause(query);
        }
        if (matches.getResultCount() > 0) {
            int count = unionQuery.countMatches(this.db, conn);
            matches.setUnionResultCount(count);
        }
        return matches;
    }

    private List<String> matchingTerms(final List<String> origParams) throws DbException {
        final ArrayList<String> result = new ArrayList<String>(origParams.size());
        UniqueStringTable.visit(this.db, this.tableclass, new UniqueStringTable.Visitor(){

            public boolean visit(long id, CharSequence s) {
                String text = ((Object)s).toString();
                for (String param : origParams) {
                    if (!text.equalsIgnoreCase(param)) continue;
                    result.add(text);
                }
                return true;
            }
        });
        return result;
    }
}

