/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep.search.query;

import com.cenqua.fisheye.cvsrep.search.query.AbstractRelationalOperatorClause;
import com.cenqua.fisheye.cvsrep.search.query.AbstractTermClause;
import com.cenqua.fisheye.cvsrep.search.query.Clause;
import com.cenqua.fisheye.cvsrep.search.query.DateRangeClause;
import com.cenqua.fisheye.cvsrep.search.query.NotClause;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.impl.CommonSchema;
import com.cenqua.fisheye.search.ClauseVisitor;
import com.cenqua.fisheye.util.ISO8601DateHelper;
import com.cenqua.obfuscate.idbk4ui8v._Cu;
import java.io.IOException;

public class DateClause
extends AbstractRelationalOperatorClause {
    private final long date;
    private final Clause delegate;

    public DateClause(long date, int op) {
        super(op);
        this.date = date;
        if (op == 1 || op == 2) {
            _Cu val = _Cu.alloc().append(date);
            AbstractTermClause clause = new AbstractTermClause(CommonSchema.E_DATE_TO_REVID, val, null){

                void toString(StringBuffer buf) {
                    DateClause.this.toString(buf);
                }
            };
            this.delegate = op == 1 ? clause : new NotClause(clause);
        } else {
            DateRangeClause clause = new DateRangeClause();
            if (op == 3) {
                clause.setMax(date);
                clause.setMaxInclusive(false);
            } else if (op == 4) {
                clause.setMax(date);
                clause.setMaxInclusive(true);
            } else if (op == 5) {
                clause.setMin(date);
                clause.setMinInclusive(false);
            } else if (op == 6) {
                clause.setMin(date);
                clause.setMinInclusive(true);
            }
            this.delegate = clause;
        }
    }

    public void accept(ClauseVisitor visitor) throws IOException, DbException {
        this.delegate.accept(visitor);
    }

    void toString(StringBuffer buf) {
        buf.append("date ");
        this.operatorToString(buf);
        buf.append(" ");
        DateClause.quoteString(ISO8601DateHelper.toIsoDate(this.date), buf);
    }
}

