/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep.search.query;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cvsrep.search.query.Clause;
import com.cenqua.fisheye.cvsrep.search.query.QueryLangLexer;
import com.cenqua.fisheye.cvsrep.search.query.QueryLangParser;
import com.cenqua.fisheye.cvsrep.search.query.ReturnClause;
import gnu.trove.TIntObjectHashMap;
import java.io.StringReader;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FishQuery {
    public static final int DEFAULT_INMEMORY_RESULT_LIMIT = Integer.MAX_VALUE;
    public static final int GB_NONE = 1;
    public static final int GB_FILE = 2;
    public static final int GB_DIR = 3;
    public static final int GB_CHANGESET = 4;
    public static final TIntObjectHashMap GB_NAMES = new TIntObjectHashMap();
    private Clause mWhereClause;
    private ReturnClause returnClause;
    private int mGroupByType = 1;
    private ORDER_BY_TYPE orderByType = ORDER_BY_TYPE.NONE;
    private Path mFromPath = null;
    private ORDER_BY_DIR orderByDirection = ORDER_BY_DIR.ASCENDING;
    private int inMemoryResultLimit = Integer.MAX_VALUE;

    public void setHintInMemoryResultLimit(int size) {
        this.inMemoryResultLimit = size;
    }

    public int getHintInMemoryResultLimit() {
        return this.inMemoryResultLimit;
    }

    public Clause getWhereClause() {
        return this.mWhereClause;
    }

    public void setWhereClause(Clause whereClause) {
        this.mWhereClause = whereClause;
    }

    public void setGroupBy(int type) {
        this.mGroupByType = type;
    }

    public int getGroupByType() {
        return this.mGroupByType;
    }

    public ORDER_BY_TYPE getOrderByType() {
        return this.orderByType;
    }

    public void setOrderBy(ORDER_BY_TYPE orderByType) {
        this.orderByType = orderByType;
    }

    public void setFromPath(Path path) {
        this.mFromPath = path;
    }

    public Path getFromPath() {
        return this.mFromPath;
    }

    public ReturnClause getReturnClause() {
        return this.returnClause;
    }

    public void setReturnClause(ReturnClause returnClause) {
        this.returnClause = returnClause;
    }

    public ORDER_BY_DIR getOrderByDirection() {
        return this.orderByDirection;
    }

    public void setOrderByDirection(ORDER_BY_DIR orderByDirection) {
        this.orderByDirection = orderByDirection;
    }

    public static FishQuery parse(String ql, List<String> errors) {
        QueryLangLexer lex = new QueryLangLexer(new StringReader(ql));
        lex.timezone = AppConfig.getsConfig().getTimezone();
        QueryLangParser parser = new QueryLangParser(lex);
        try {
            return parser.query();
        }
        catch (RecognitionException e2) {
            errors.add("error parsing query: " + e2.getMessage());
        }
        catch (TokenStreamException e3) {
            errors.add("error parsing query: " + e3.getMessage());
        }
        return null;
    }

    public String makeQueryString() {
        StringBuffer buf = new StringBuffer();
        buf.append("select revisions");
        if (this.mFromPath != null) {
            buf.append(" from dir /").append(this.mFromPath);
        }
        if (this.mWhereClause != null) {
            buf.append(" where ");
            this.mWhereClause.toString(buf);
        }
        if (this.mGroupByType != 1) {
            buf.append(" group by ").append(GB_NAMES.get(this.mGroupByType));
        }
        if (this.returnClause != null) {
            buf.append(" return ");
            this.returnClause.toString(buf);
        }
        return buf.toString();
    }

    static {
        GB_NAMES.put(2, (Object)"file");
        GB_NAMES.put(3, (Object)"dir");
        GB_NAMES.put(4, (Object)"changeset");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ORDER_BY_DIR {
        ASCENDING,
        DESCENDING;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ORDER_BY_TYPE {
        NONE,
        DATE;

    }
}

