/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep.search.query;

import com.cenqua.crucible.model.managers.StateManager;
import com.cenqua.fisheye.cvsrep.search.query.Clause;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.search.ClauseVisitor;
import java.io.IOException;
import java.util.EnumSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReviewClause
extends Clause {
    private final boolean in;
    private final boolean before;
    private final String permaid;
    private final EnumSet<StateManager.MetaState> metaStates;

    public ReviewClause(boolean in, boolean before, String permaid, EnumSet<StateManager.MetaState> metaStates) {
        this.in = in;
        this.before = before;
        this.permaid = permaid;
        this.metaStates = metaStates;
    }

    @Override
    public void accept(ClauseVisitor visitor) throws DbException, IOException {
        visitor.visitReviewClause(this);
    }

    public EnumSet<StateManager.MetaState> getMetaStates() {
        return this.metaStates;
    }

    public boolean isIn() {
        return this.in;
    }

    public boolean isBefore() {
        return this.before;
    }

    public String getPermaid() {
        return this.permaid;
    }

    @Override
    void toString(StringBuffer buf) {
        if (this.in) {
            buf.append("in ");
            if (this.before) {
                buf.append("or before ");
            }
        } else if (this.before) {
            buf.append("before ");
        }
        if (this.permaid != null) {
            buf.append("review ");
            ReviewClause.quoteString(this.permaid, buf);
        }
        if (this.metaStates != null) {
            buf.append("any ");
            if (!this.metaStates.equals(EnumSet.allOf(StateManager.MetaState.class))) {
                String sep = "";
                if (this.metaStates.contains((Object)StateManager.MetaState.DRAFT)) {
                    buf.append(sep).append("draft");
                    sep = ", ";
                }
                if (this.metaStates.contains((Object)StateManager.MetaState.OPEN)) {
                    buf.append(sep).append("open");
                    sep = ", ";
                }
                if (this.metaStates.contains((Object)StateManager.MetaState.CLOSED)) {
                    buf.append(sep).append("closed");
                    sep = ", ";
                }
                buf.append(" ");
            }
            buf.append("review");
        }
    }
}

