/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.diff;

import com.cenqua.fisheye.util.StringUtil;

public abstract class LineComparator {
    public static final Identical IDENTICAL = new Identical();
    public static final IgnoreSpaceChange IGNORE_SPACE_CHANGE = new IgnoreSpaceChange();
    public static final IgnoreAllSpace IGNORE_ALL_SPACE = new IgnoreAllSpace();
    private final boolean mSupportsIgnore;

    public LineComparator(boolean supportsIgnore) {
        this.mSupportsIgnore = supportsIgnore;
    }

    public static LineComparator fromDiffOption(String opt) {
        boolean found_B;
        if (opt == null) {
            return IDENTICAL;
        }
        boolean found_w = opt.indexOf("w") != -1;
        boolean found_b = opt.indexOf("b") != -1;
        boolean bl = found_B = opt.indexOf("B") != -1;
        if (found_B) {
            return new IgnoreBlankLines(found_b, found_w);
        }
        if (found_w) {
            return IGNORE_ALL_SPACE;
        }
        if (found_b) {
            return IGNORE_SPACE_CHANGE;
        }
        return IDENTICAL;
    }

    public abstract boolean equals(StringBuffer var1, StringBuffer var2);

    public abstract int hashcode(StringBuffer var1);

    public boolean supportsIgnore() {
        return this.mSupportsIgnore;
    }

    public boolean ignore(StringBuffer line) {
        return false;
    }

    private static void removeSpaceChanges(StringBuffer buf) {
        while (buf.length() > 0 && Character.isWhitespace(buf.charAt(buf.length() - 1))) {
            buf.setLength(buf.length() - 1);
        }
        int i2 = 0;
        boolean inWhitespaceSpan = false;
        while (i2 < buf.length()) {
            char c2 = buf.charAt(i2);
            if (Character.isWhitespace(c2)) {
                if (inWhitespaceSpan) {
                    buf.deleteCharAt(i2);
                    continue;
                }
                buf.setCharAt(i2, ' ');
                ++i2;
                inWhitespaceSpan = true;
                continue;
            }
            ++i2;
            inWhitespaceSpan = false;
        }
    }

    private static void removeSpaces(StringBuffer buf) {
        int i2 = 0;
        while (i2 < buf.length()) {
            char c2 = buf.charAt(i2);
            if (Character.isWhitespace(c2)) {
                buf.deleteCharAt(i2);
                continue;
            }
            ++i2;
        }
    }

    private static boolean stringsIdentical(StringBuffer a2, StringBuffer b2) {
        if (a2.length() != b2.length()) {
            return false;
        }
        for (int i2 = 0; i2 < a2.length(); ++i2) {
            char cb;
            char ca = a2.charAt(i2);
            if (ca == (cb = b2.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public String toDiffOptsString() {
        return null;
    }

    public static class IgnoreBlankLines
    extends LineComparator {
        private final boolean mIgnoreChange;
        private final boolean mIgnoreAllSpace;

        public IgnoreBlankLines(boolean ignoreChange, boolean ignoreAllSpace) {
            super(true);
            this.mIgnoreChange = ignoreChange;
            this.mIgnoreAllSpace = ignoreAllSpace;
        }

        public boolean equals(StringBuffer a2, StringBuffer b2) {
            this.cleanup(a2);
            this.cleanup(b2);
            return LineComparator.stringsIdentical(a2, b2);
        }

        public int hashcode(StringBuffer line) {
            this.cleanup(line);
            return StringUtil.stringHashCode(line);
        }

        public boolean ignore(StringBuffer line) {
            this.cleanup(line);
            return line.length() == 0;
        }

        private void cleanup(StringBuffer line) {
            StringUtil.stripEOL(line);
            if (this.mIgnoreAllSpace) {
                LineComparator.removeSpaces(line);
            }
            if (this.mIgnoreChange) {
                LineComparator.removeSpaceChanges(line);
            }
        }

        public String toDiffOptsString() {
            return "B" + (this.mIgnoreAllSpace ? "w" : "") + (this.mIgnoreChange ? "b" : "");
        }
    }

    public static class IgnoreAllSpace
    extends Identical {
        public boolean equals(StringBuffer a2, StringBuffer b2) {
            LineComparator.removeSpaces(a2);
            LineComparator.removeSpaces(b2);
            return super.equals(a2, b2);
        }

        public int hashcode(StringBuffer line) {
            LineComparator.removeSpaces(line);
            return super.hashcode(line);
        }

        public String toDiffOptsString() {
            return "w";
        }
    }

    public static class IgnoreSpaceChange
    extends Identical {
        public boolean equals(StringBuffer a2, StringBuffer b2) {
            LineComparator.removeSpaceChanges(a2);
            LineComparator.removeSpaceChanges(b2);
            return super.equals(a2, b2);
        }

        public int hashcode(StringBuffer line) {
            LineComparator.removeSpaceChanges(line);
            return super.hashcode(line);
        }

        public String toDiffOptsString() {
            return "b";
        }
    }

    public static class Identical
    extends LineComparator {
        public Identical() {
            super(false);
        }

        public boolean equals(StringBuffer a2, StringBuffer b2) {
            return LineComparator.stringsIdentical(a2, b2);
        }

        public int hashcode(StringBuffer line) {
            return StringUtil.stringHashCode(line);
        }
    }
}

