/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.diff;

public final class PathNode {
    public final int i;
    public final int j;
    public final PathNode prev;
    public final boolean snake;

    private PathNode(int i2, int j, PathNode prev, boolean snake) {
        this.i = i2;
        this.j = j;
        this.prev = prev;
        this.snake = snake;
    }

    public static PathNode Snake(int i2, int j, PathNode prev) {
        return new PathNode(i2, j, prev, true);
    }

    public static PathNode DiffNode(int i2, int j, PathNode prev) {
        return new PathNode(i2, j, prev == null ? null : prev.previousSnake(), false);
    }

    public boolean isBootstrap() {
        return this.i < 0 || this.j < 0;
    }

    public final PathNode previousSnake() {
        if (this.isBootstrap()) {
            return null;
        }
        if (!this.snake && this.prev != null) {
            return this.prev.previousSnake();
        }
        return this;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("[");
        PathNode node = this;
        while (node != null) {
            buf.append("(");
            buf.append(Integer.toString(node.i));
            buf.append(",");
            buf.append(Integer.toString(node.j));
            buf.append(")");
            node = node.prev;
        }
        buf.append("]");
        return buf.toString();
    }
}

