/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.diff;

import com.cenqua.fisheye.diff.DiffSequences;
import com.cenqua.fisheye.diff.Hunk;
import gnu.trove.TIntArrayList;

public abstract class RemappingDiffSequences
extends DiffSequences {
    private TIntArrayList mOrigHashes;
    private TIntArrayList mRevisedHashes;
    protected final boolean mIsIgnoreEnabled;

    protected RemappingDiffSequences(boolean isIgnoreEnabled) {
        this.mIsIgnoreEnabled = isIgnoreEnabled;
    }

    protected void setup(TIntArrayList origHashes, TIntArrayList revisedHashes) {
        this.mOrigHashes = origHashes;
        this.mRevisedHashes = revisedHashes;
    }

    public int getOriginalSize() {
        return this.mOrigHashes.size();
    }

    public int getRevisedSize() {
        return this.mRevisedHashes.size();
    }

    public boolean ignore(Hunk hunk) {
        if (!this.mIsIgnoreEnabled) {
            return false;
        }
        return this.shouldIgnore(true, hunk.getFrom(), hunk.getFromCount()) && this.shouldIgnore(false, hunk.getTo(), hunk.getToCount());
    }

    private boolean shouldIgnore(boolean fromSide, int start, int count) {
        for (int i2 = start; i2 < start + count; ++i2) {
            boolean ignore;
            boolean bl = ignore = fromSide ? this.ignoreOriginalLine(i2) : this.ignoreRevisedLine(i2);
            if (ignore) continue;
            return false;
        }
        return true;
    }

    public boolean equal(int aOriginalIndex, int aRevisionIndex) {
        if (this.mOrigHashes.get(aOriginalIndex) != this.mRevisedHashes.get(aRevisionIndex)) {
            return false;
        }
        return this.equalImpl(aOriginalIndex, aRevisionIndex);
    }

    protected abstract boolean equalImpl(int var1, int var2);

    protected abstract boolean ignoreOriginalLine(int var1);

    protected abstract boolean ignoreRevisedLine(int var1);
}

