/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.infinitydb.query3;

import com.cenqua.fisheye.infinitydb.query3.NotQuery3;
import com.cenqua.fisheye.infinitydb.query3.Query3;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.obfuscate.idbk4ui8v._AndOrSpace;
import com.cenqua.obfuscate.idbk4ui8v._AndSpace;
import com.cenqua.obfuscate.idbk4ui8v._ItemSpace;
import com.cenqua.obfuscate.idbk4ui8v._OrSpace;
import gnu.trove.TIntHashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.lucene.index.IndexReader;

public abstract class BooleanQuery3
extends Query3 {
    private final List clauses = new LinkedList();

    public BooleanQuery3 addClause(Query3 clause) {
        if (clause == null) {
            throw new IllegalArgumentException("clause was null");
        }
        this.clauses.add(clause);
        return this;
    }

    public Query3 simplify() {
        if (this.clauses.size() == 1) {
            return ((Query3)this.clauses.get(0)).simplify();
        }
        return this;
    }

    protected void calculateRequiredReaders(TIntHashSet requiredReaders) {
        for (Query3 clause : this.clauses) {
            clause.calculateRequiredReaders(requiredReaders);
        }
    }

    protected _ItemSpace asItemSpace(_ItemSpace source, IndexReader[] readers) throws DbException {
        if (this.clauses.size() == 1) {
            Query3 clause = (Query3)this.clauses.get(0);
            return clause.simplify().asItemSpace(source, readers);
        }
        _AndOrSpace result = this.isAnd() ? new _AndSpace() : new _OrSpace();
        LinkedList<_ItemSpace> negativeParts = new LinkedList<_ItemSpace>();
        for (Query3 clause : this.clauses) {
            clause = clause.simplify();
            boolean positive = true;
            while (clause instanceof NotQuery3 && this.isAnd()) {
                NotQuery3 notClause = (NotQuery3)clause;
                clause = notClause.getDelegate().simplify();
                positive = !positive;
            }
            _ItemSpace is = clause.asItemSpace(source, readers);
            if (positive) {
                if (this.isAnd() ? is instanceof _AndSpace : is instanceof _OrSpace) {
                    _AndOrSpace nested = (_AndOrSpace)is;
                    for (int j = 0; j < nested.size(); ++j) {
                        result.add(nested.spaceAt(j), nested.isPositiveAt(j));
                    }
                    continue;
                }
                result.add(is);
                continue;
            }
            negativeParts.add(is);
        }
        if (result.size() == 0 && !negativeParts.isEmpty() && this.isAnd()) {
            _ItemSpace first = (_ItemSpace)negativeParts.removeFirst();
            result.add(NotQuery3.negateItemSpace(source, first));
        }
        for (_ItemSpace is : negativeParts) {
            result.add(is, false);
        }
        return result;
    }

    protected abstract boolean isAnd();

    public void toString(StringBuffer s) {
        s.append(this.isAnd() ? "And" : "Or").append("(");
        String sep = "";
        for (Query3 clause : this.clauses) {
            s.append(sep);
            s.append(clause);
            sep = ", ";
        }
        s.append(")");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BooleanQuery3 that = (BooleanQuery3)o;
        return ((Object)this.clauses).equals(that.clauses);
    }

    public int hashCode() {
        return ((Object)this.clauses).hashCode();
    }
}

