/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.perforce;

import com.cenqua.fisheye.perforce.client.P4ChangePath;
import com.cenqua.fisheye.perforce.client.P4FileSpec;
import com.cenqua.fisheye.util.LineCounter;
import java.io.IOException;
import java.io.OutputStream;
import java.text.ParsePosition;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P4MultiLineCountStream
extends OutputStream {
    private static final int MAX_LINE = 8192;
    private StringBuilder currentLine = new StringBuilder();
    private P4FileSpec currentSpec;
    private long currentCount;
    private LineCounter counter = new LineCounter();
    private Map<P4FileSpec, P4ChangePath> files;
    private CountVisitor visitor;

    public P4MultiLineCountStream(Map<P4FileSpec, P4ChangePath> files, CountVisitor visitor) {
        this.files = files;
        this.visitor = visitor;
    }

    @Override
    public void write(int b2) throws IOException {
        boolean eol = this.counter.process(b2);
        if (!eol) {
            if (b2 != 10) {
                if (this.currentLine.length() < 8192) {
                    this.currentLine.append((char)b2);
                } else {
                    this.currentLine.delete(0, this.currentLine.length() - 4096);
                }
            }
        } else {
            if (this.counter.getCharCount() > this.currentCount) {
                P4FileSpec newSpec;
                ParsePosition start = new ParsePosition(0);
                ParsePosition end = new ParsePosition(this.currentLine.length());
                while ((newSpec = P4FileSpec.match(this.currentLine, start, end)) != null) {
                    String followingString = this.currentLine.substring(end.getIndex());
                    if (this.files.containsKey(newSpec) && followingString.startsWith(" - ")) {
                        this.sendCount(start.getIndex() == 0 ? -1 : 0);
                        this.counter.resetCount();
                        this.currentSpec = newSpec;
                        Long size = this.files.get(this.currentSpec).getFileSize();
                        this.currentCount = size;
                        break;
                    }
                    start.setIndex(start.getIndex() + 1);
                }
            }
            this.currentLine.setLength(0);
        }
    }

    private void sendCount(int adjust) {
        if (this.currentSpec != null) {
            int count = this.counter.getLineCount();
            this.visitor.visit(this.currentSpec, count += adjust);
        }
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.sendCount(this.currentLine.length() != 0 ? 1 : 0);
    }

    public static interface CountVisitor {
        public void visit(P4FileSpec var1, int var2);
    }
}

