/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.perforce.client;

import com.cenqua.fisheye.diff.Hunk;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.perforce.P4RepositoryInfo;
import com.cenqua.fisheye.perforce.client.P4ChangeList;
import com.cenqua.fisheye.perforce.client.P4ChangePath;
import com.cenqua.fisheye.perforce.client.P4CliUtils;
import com.cenqua.fisheye.perforce.client.P4ClientException;
import com.cenqua.fisheye.perforce.client.P4FileSpec;
import com.cenqua.fisheye.perforce.client.P4OutputLineProcessor;
import com.cenqua.fisheye.util.diff.HunkFactory;
import com.cenqua.fisheye.util.diff.SectionSpec;
import java.text.ParsePosition;
import java.util.List;
import java.util.SortedMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescribeProcessor
extends P4OutputLineProcessor {
    private static final Pattern SUMMARY_ADD = Pattern.compile("add (\\d+) chunks (\\d+) lines");
    private static final Pattern SUMMARY_DELETED = Pattern.compile("deleted (\\d+) chunks (\\d+) lines");
    private static final Pattern SUMMARY_CHANGED = Pattern.compile("changed (\\d+) chunks (\\d+) / (\\d+) lines");
    private static final Pattern CHANGE_HEADER = Pattern.compile("(.*)(Change [0-9]* by .* on .*$)");
    private static final Pattern RCS_ADD = Pattern.compile("a([0-9]+) ([0-9]+)");
    private static final Pattern RCS_DELETE = Pattern.compile("d([0-9]+) ([0-9]+)");
    private DescribeType describeType;
    private int rcsAddCount;
    private int rcsCurrentOffset;
    private P4ChangeList currentChangeList;
    private P4ChangePath currentPath;
    private DiffState state;
    private final SortedMap<Long, P4ChangeList> changeLists;
    private P4RepositoryInfo repoInfo;
    private HunkFactory hunkFactory;

    public DescribeProcessor(P4RepositoryInfo repoInfo, SortedMap<Long, P4ChangeList> changeLists, DescribeType describeType) {
        super(repoInfo.isUnicode() ? "UTF-8" : null);
        this.repoInfo = repoInfo;
        this.changeLists = changeLists;
        this.currentChangeList = null;
        this.currentPath = null;
        this.state = DiffState.NONE;
        this.describeType = describeType;
        this.hunkFactory = new HunkFactory(){

            public void addHunk(Hunk hunk) {
                DescribeProcessor.this.currentPath.addHunk(hunk);
            }
        };
    }

    private P4FileSpec processDiffSpec(String line) {
        int endMarkerIndex = line.lastIndexOf(" ====");
        P4FileSpec fileSpec = null;
        if (endMarkerIndex != -1) {
            String diffSpec = line.substring(5, endMarkerIndex);
            fileSpec = P4FileSpec.match(diffSpec, new ParsePosition(0));
        }
        return fileSpec;
    }

    @Override
    public void processLine(String infoLine) {
        Matcher changeMatcher;
        boolean doSearch = this.state != DiffState.CHANGE && this.state != DiffState.AFFECTED;
        boolean matched = false;
        if (doSearch && (changeMatcher = CHANGE_HEADER.matcher(infoLine)).matches()) {
            String preceedingLine = changeMatcher.group(1);
            if (preceedingLine != null && preceedingLine.trim().length() != 0) {
                this.processChangeLine(preceedingLine);
            }
            String changeLine = changeMatcher.group(2);
            List<String> changeElements = P4CliUtils.getLineElements(changeLine);
            long changeListId = Long.parseLong(changeElements.get(1));
            this.currentChangeList = (P4ChangeList)this.changeLists.get(changeListId);
            this.setState(DiffState.CHANGE);
            matched = true;
        }
        if (!matched) {
            this.processChangeLine(infoLine);
        }
    }

    public void processChangeLine(String infoLine) {
        if (infoLine.startsWith("Differences ...")) {
            this.setState(DiffState.DIFFS);
        } else if (infoLine.startsWith("Affected files ...")) {
            this.setState(DiffState.AFFECTED);
        } else if (this.isFileDiffState() && infoLine.startsWith("====")) {
            this.processFileSpecLine(infoLine);
        } else if (infoLine.startsWith("Jobs fixed ...")) {
            this.setState(DiffState.FIXES);
        } else {
            switch (this.state) {
                case AFFECTED: {
                    ParsePosition pos;
                    P4FileSpec fileSpec;
                    if (infoLine.trim().length() == 0 || !this.repoInfo.isPathInRepo((fileSpec = P4FileSpec.match(infoLine, pos = new ParsePosition(4))).getPath(), this.currentChangeList.getId())) break;
                    P4ChangePath changePath = this.currentChangeList.getChangePath(fileSpec.getPath());
                    if (changePath == null) {
                        changePath = new P4ChangePath(fileSpec);
                        this.currentChangeList.addChangePath(changePath);
                    }
                    changePath.setAction(infoLine.substring(pos.getIndex() + 1).trim());
                    break;
                }
                case FILEDIFF: {
                    switch (this.describeType) {
                        case UNIFIED: {
                            this.hunkFactory.startSection(new SectionSpec(infoLine));
                            this.setState(DiffState.SECTION);
                            break;
                        }
                        case SUMMARY: {
                            boolean matched = false;
                            Matcher matcher = SUMMARY_ADD.matcher(infoLine);
                            if (matcher.find()) {
                                matched = true;
                                this.currentPath.incAdded(Integer.parseInt(matcher.group(2)));
                            }
                            if (!matched && (matcher = SUMMARY_DELETED.matcher(infoLine)).find()) {
                                matched = true;
                                this.currentPath.incRemoved(Integer.parseInt(matcher.group(2)));
                            }
                            if (matched || !(matcher = SUMMARY_CHANGED.matcher(infoLine)).find()) break;
                            int removed = Integer.parseInt(matcher.group(2));
                            int added = Integer.parseInt(matcher.group(3));
                            this.currentPath.incAdded(added);
                            this.currentPath.incRemoved(removed);
                            break;
                        }
                        case RCS: {
                            this.setState(DiffState.RCS_OUTPUT);
                            this.resetRCS();
                            this.processRCSOutput(infoLine);
                        }
                    }
                    break;
                }
                case SECTION: {
                    if (SectionSpec.isValidSection(infoLine)) {
                        this.hunkFactory.endSection();
                        this.hunkFactory.startSection(new SectionSpec(infoLine));
                        break;
                    }
                    if (infoLine.startsWith("+")) {
                        this.hunkFactory.addLine();
                        this.currentPath.incAdded(1);
                        break;
                    }
                    if (infoLine.startsWith("-")) {
                        this.hunkFactory.removeLine();
                        this.currentPath.incRemoved(1);
                        break;
                    }
                    if (!infoLine.startsWith(" ")) break;
                    this.hunkFactory.contextLine();
                    break;
                }
                case RCS_OUTPUT: {
                    this.processRCSOutput(infoLine);
                }
            }
        }
    }

    private P4FileSpec processFileSpecLine(String infoLine) {
        P4FileSpec fileSpec = this.processDiffSpec(infoLine);
        if (fileSpec != null) {
            P4ChangePath newPath;
            if (this.repoInfo.isPathInRepo(fileSpec.getPath(), this.currentChangeList.getId())) {
                newPath = this.currentChangeList.getChangePath(fileSpec.getPath());
                if (newPath == null) {
                    newPath = new P4ChangePath(fileSpec);
                    this.currentChangeList.addChangePath(newPath);
                }
            } else {
                newPath = new P4ChangePath(fileSpec);
            }
            this.setState(DiffState.FILEDIFF);
            this.currentPath = newPath;
        }
        return fileSpec;
    }

    private boolean isFileDiffState() {
        return this.state == DiffState.DIFFS || this.state == DiffState.FILEDIFF || this.state == DiffState.SECTION;
    }

    private void resetRCS() {
        this.rcsAddCount = 0;
        this.rcsCurrentOffset = 0;
    }

    private void processRCSOutput(String infoLine) {
        if (this.rcsAddCount == 0) {
            P4FileSpec fileSpec;
            int start;
            if (infoLine.trim().length() == 0) {
                return;
            }
            boolean matched = false;
            Matcher matcher = RCS_ADD.matcher(infoLine);
            if (matcher.matches()) {
                start = Integer.parseInt(matcher.group(1));
                this.rcsAddCount = Integer.parseInt(matcher.group(2));
                Hunk hunk = new Hunk(start, start + this.rcsCurrentOffset + 1, 0, this.rcsAddCount);
                this.currentPath.addHunk(hunk);
                this.rcsCurrentOffset += this.rcsAddCount;
                this.currentPath.incAdded(this.rcsAddCount);
                matched = true;
            }
            if (!matched && (matcher = RCS_DELETE.matcher(infoLine)).matches()) {
                start = Integer.parseInt(matcher.group(1));
                int delCount = Integer.parseInt(matcher.group(2));
                Hunk hunk = new Hunk(start, start + this.rcsCurrentOffset + 1, delCount, 0);
                this.rcsCurrentOffset -= delCount;
                this.currentPath.addHunk(hunk);
                this.currentPath.incRemoved(delCount);
                matched = true;
            }
            if (!matched && infoLine.startsWith("====") && (fileSpec = this.processFileSpecLine(infoLine)) != null) {
                matched = true;
            }
            if (!matched) {
                Logs.APP_LOG.warn((Object)("Unexpected line" + infoLine));
            }
        } else {
            --this.rcsAddCount;
        }
    }

    @Override
    public String complete(String exitStatus) throws P4ClientException {
        this.setState(DiffState.NONE);
        return super.complete(exitStatus);
    }

    private void setState(DiffState newState) {
        if (this.state == DiffState.SECTION) {
            this.hunkFactory.endSection();
        }
        this.state = newState;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DescribeType {
        RCS,
        SUMMARY,
        UNIFIED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DiffState {
        NONE,
        CHANGE,
        AFFECTED,
        DIFFS,
        FILEDIFF,
        SECTION,
        RCS_OUTPUT,
        FIXES;

    }
}

