/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.util.BaseThreadedProcessor;
import com.cenqua.fisheye.util.Disposer;

public class CacheWarmer
extends BaseThreadedProcessor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processEvent(Object event) throws Exception {
        Disposer.pushThreadInstance();
        try {
            this.warm((String)event);
        }
        finally {
            Disposer.popThreadInstance();
        }
    }

    private void warm(String repname) throws DbException {
        RepositoryEngine eng;
        Logs.PERF_LOG.debug((Object)("Warming " + repname));
        RepositoryHandle rh = AppConfig.getsConfig().getRepositoryManager().getRepository(repname);
        if (rh == null) {
            Logs.APP_LOG.info((Object)("couldn't find repository " + repname));
            return;
        }
        try {
            eng = rh.acquireEngine();
        }
        catch (RepositoryHandle.StateException e2) {
            Logs.APP_LOG.debug((Object)("repository wasn't running: " + repname));
            return;
        }
        eng.getDirTreeCache().warm();
    }
}

